## 6.10.2

### en

**Bug fixes:**

* Restores compatibility with PHP 8.
* Fixes a bug that caused the parameter "useNumberAsId" of the Shopware REST API not to be considered correctly.

### de

**Fehlerbehebungen:**

* Stellt die Kompatibilität mit PHP 8 wieder her.
* Behebt einen Fehler, der dazu führte, dass der Parameter "useNumberAsId" der Shopware REST API nicht richtig berücksichtigt wurde.


## 6.10.1

### en

**Bug fixes:**

* Fixes an error that could cause the deletion of saved stock valuation reports to fail.

### de

**Fehlerbehebungen:**

* Behebt ein Fehler, der dazu führte, dass das Löschen von gespeicherten Berichten des bewerteten Warenbestands fehlschlagen konnte.


## 6.10.0

### en

**New features and improvements:**

* Increases the timeout for generating a report for stock valuation to 10 minutes.

**Bug fixes:**

* Fixes an error that caused error messages to be displayed incorrectly when generating a report for stock valuation.

### de

**Neue Funktionen und Verbesserungen:**

* Erhöht den Timeout für das Erstellen des bewerteten Warenbestands auf 10 Minuten.

**Fehlerbehebungen:**

* Behebt ein Fehler, der dazu führte, dass Fehlermeldungen beim Erzeugen der Bestandsbewertung nicht korrekt dargestellt wurden.


## 6.9.1

### en

**Bug fixes:**

* Fixes a compatibility issue with PHP 7.4.21 and PHP 8.0.8.

### de

**Fehlerbehebungen:**

* Behebt ein Kompatibilitätsproblem mit PHP 7.4.21 und PHP 8.0.8.


## 6.9.0

### en

**New features and improvements:**

* Improved performance when generating a report for stock valuation.

**Bug fixes:**

* The re-generation of a report for the stock valuation now always produces the same results, if the
  underlying inventory data has not changed.

### de

**Neue Funktionen und Verbesserungen:**

* Die Performance beim Erzeugen eines Berichtes für die Bestandsbewertung wurde verbessert.

**Fehlerbehebungen:**

* Die erneute Erzeugung eines Berichtes für die Bestandsbewertung liefert nun immer die gleichen Ergebnisse, wenn die
  zugrunde liegenden Bestandsdaten sich nicht geändert haben.

## 6.8.1

### en

**Bug fixes:**

* Fixes a bug that could cause the installation and update to fail when using Shopware 5.5.8 or lower.

### de

**Fehlerbehebungen:**

* Behebt einen Fehler, der dazu führen konnte, dass die Installation und das Update mit Shopware 5.5.8 oder niedriger nicht korrekt durchgeführt wurden.


## 6.8.0

### en

**New features and improvements:**

* Enables compatibility with Shopware 5.7.

**Bug fixes:**

* Fixes a bug that causes the "Sales Ratio" evaluation not to display all entries.

### de

**Neue Funktionen und Verbesserungen:**

* Stellt die Kompatibilität mit Shopware 5.7 her.

**Fehlerbehebungen:**

* Behebt einen Fehler, der dazu führt, dass die Auswertung "Abverkaufsquote" nicht alle Einträge anzeigt.


## 6.7.3

### en

* Meta information, such as product images, is now also available in the document template of pick lists.
* If the delivered quantity exceeds the ordered quantity for items of a supplier order, the logged stock is no longer reduced as soon as the status of the supplier order is set to "Completely delivered".
* The API logs can now be viewed in the backend again, even if the request data of individual log entries is too large.

### de

* Meta Informationen, wie beispielsweise Produktbilder, stehen nun auch im Dokumenten-Template von Picklisten für Bestellpositionen zur Verfügung.
* Sofern die Liefermenge die Bestellmenge für einzelne Positionen einer Lieferantenbestellung übersteigt, wird der eingebuchte Bestand nicht mehr nachträglich reduziert, sobald der Status der Lieferantenbestellung auf "Komplett geliefert" gesetzt wird.
* Die API Logs können nun wieder im Backend eingesehen werden, selbst wenn die Request Data einzelner Logeinträge zu groß ist.


## 6.7.2

### en

* Reports for stock valuations can now be exported and deleted again, even if Shopware <= 5.5 is used.

### de

* Berichte für Bestandsbewertungen (Bewerteter Warenbestand) können nun wieder exportiert und gelöscht werden, auch wenn Shopware <= 5.5 verwendet wird.


## 6.7.1

### en

* The supplier order detail view shows all order positions now. The view limit of 1000 positions was removed.
* The following plugins have been marked as incompatible:
  * "Automatische Zahlungserinnerung, Mahnungen und Workflows - Workflow Manager" (up to and including version 17.5.0)
  * Reserve items in the shopping cart (for a specific time)
  * Copy (CC and BCC) from transmitted e-mails
  * Order cancel with inventory correction

### de

* Es werden nun alle Positionen einer Lieferantenbestellung in der Detailseite einer Lieferantenbestellung angezeigt. Das Listenlimit von 1000 Positionen wurde entfernt.
* Die folgenden Plugins wurden als inkompatibel markiert:
  * Automatische Zahlungserinnerung, Mahnungen und Workflows - Workflow Manager (bis einschließlich Version 17.5.0)
  * Artikel im Warenkorb (für bestimmte Zeit) reservieren
  * Kopien (CC und BCC) ausgehender E-Mails erhalten
  * Storno mit automatischer Bestandskorrektur


## 6.7.0

### en

* Completely reworked and improved version of the "Stock valuation".
* It is now possible to choose between the LIFO, FIFO and weighted average valuation methods for the "Stock valuation".
* It is now possible to permanently save the "Stock valuation" report of a specific date and reopen it in the backend at any time.

### de

* Komplett überarbeitete und verbesserte Version des "Bewerteten Warenbestands".
* In den Plugineinstellungen kann für den "Bewerteten Warenbestand" ab sofort zwischen den Bewertungsverfahren LIFO, FIFO und dem gewogenen Durchschnitt gewählt werden.
* Der "Bewertete Warenbestand" kann ab sofort zu jedem beliebigen Stichtag dauerhaft als Bericht gespeichert und über das Backend erneut aufgerufen werden.


## 6.6.7

### en

* Fixed a bug that caused the CSV file to be created incorrectly when exporting "Rated Stock" and product names contained CSV separators such as ";".
* Improves the performance of the article detail window when saving articles with many variants.
+ Fixes a bug that could cause the cancellation of net orders with positions with a 0% tax rate to fail.
* Fixes a bug that prevented missing article attributes from being created automatically when e.g. importing stocks.

### de

* Behebt einen Fehler, der dazu führte, dass beim Export von "Bewerteter Warenbestand" die CSV-Datei fehlerhaft erstellt wurde, wenn in Artikelnamen CSV-Trennzeichen (wie z.B. ";") enthalten waren.
* Verbessert die Performance des Artikel Detail Fensters beim Speichern von Artikeln mit vielen Varianten.
* Behebt einen Fehler, der dazu führen konnte, dass das Stornieren von Nettobestellungen mit Positionen mit einem Steuersatz von 0% fehlschlug.
* Behebt einen Fehler, der unter anderem beim Bestandsimport verhinderte, dass fehlende Artikelattribute automatisch angelegt wurden.


## 6.6.6

### en

* Fixes a bug which caused the api request log truncating to fail.

### de

* Behebt einen Fehler, der dazu führte, dass das Aufräumen des API-Logs fehlschlug.


## 6.6.5

### en

* Improves the performance of the article detail window for articles with many variants.
* Fixes an error that caused the price and pack units on supplier order documents to not be translated.
* Fixes an error that caused the supplier filter in the list of supplier orders to display no more than 25 suppliers.
* Fixes an error that caused an error message to be displayed when entering characters in the " Supplier" or " Warehouse" filter of the supplier order window.

### de

* Verbessert die Performance des Artikel Detail Fensters von Artikeln mit vielen Varianten.
* Behebt einen Fehler, der dazu führte, dass die Preis- und Verpackungseinheiten auf Lieferantenbestelldokumenten nicht übersetzt wurden.
* Behebt einen Fehler, der dazu führte, dass der Lieferantenfilter im Lieferantenbestellwesen nicht mehr als 25 Lieferanten anzeigte.
* Behebt einen Fehler, der dazu führte, dass bei der Eingabe von Zeichen im "Lieferanten" oder "Lager" Filter des Lieferantenbestellwesen eine Fehlermeldung angezeigt wurde.


## 6.6.4

### en

* Adds an incompatibility warning for plugin "Automatische Zahlungserinnerung und Mahnungen".
* Fixes a bug that caused the label layout "2 columns (2 rows / barcode)" to display images incorrectly.

### de

* Fügt einen Inkompatibilitätshinweis für das Plugin "Automatische Zahlungserinnerung und Mahnungen" hinzu.
* Behebt einen Fehler, der dazu führte, dass im Etikettenlayout "2 Spalten (2 Zeilen / Barcode)" Bilder falsch dargestellt wurden.


## 6.6.3

### en

* Improves the performance of REST API requests with high request volumes.

### de

* Verbessert die Performance von REST API-Anfragen bei hohem Anfragevolumen.


## 6.6.2

### en

* Fixes a bug that prevented the stock overview from working when using MySQL version 8.0.19 or higher.

### de

* Behebt einen Fehler, der dazu führte, dass die Bestandsübersicht mit MySQL in Version 8.0.19 oder höher nicht funktionierte.


## 6.6.1

### en

* Fixes a bug which could, under certain circumstances, lead to supplier orders stock to be reduced again after it has already been increased.

### de

* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass bereits eingelagerte Lieferantenbestellungen wieder ausgelagert wurden.


## 6.6.0

### en

* Adds a checkbox for disabling automatic sending of status emails when finalizing multiple returns.
* Improves error handling during stock initialization.
* Adds the company name to the customer name in the return overview and the list of returnable orders.
* Fixes a bug that caused preview images not to be displayed for attachments of returns.
* Adds the possibility to filter the list of supplier orders according to various criteria.
* Fixes a bug that caused articles marked as "not stock-managed" via the multi-edit function to continue having stocks on bin locations.
* Fixes a bug that caused barcode labels not to be printed in the order they were displayed in the backend.

### de

* Fügt die Möglichkeit hinzu, das automatische Senden von Status E-Mails beim Abschließen mehrerer Retouren zu deaktivieren.
* Verbessert die Fehlerbehandlung bei der Lagerinitialisierung.
* Fügt den Firmennamen zum Kundennamen in der Retourenübersicht und der Liste der retournierbaren Bestellungen hinzu.
* Behebt einen Fehler, der dazu führte, dass für Anhänge von Retouren keine Vorschau Bilder angezeigt wurden.
* Fügt die Möglichkeit hinzu, die Liste der Lieferantenbestellungen nach verschiedenen Kriterien zu filtern.
* Behebt einen Fehler, der dazu führte, dass Artikel, die über die Mehrfachänderung als "nicht bestandsgeführt" markiert wurden, weiterhin Bestände auf Lagerplätzen besaßen.
* Behebt einen Fehler, der dazu führte, dass Etiketten nicht in der Reihenfolge gedruckt wurden, in der sie im Backend angezeigt wurden.


## 6.5.5

### en

* Fixes a bug that caused the CSV export file of a supplier order to be saved as PDF.

### de

* Behebt einen Fehler, der dazu führte, dass der CSV-Export einer Lieferantenbestellung fälschlicherweise als PDF gespeichert wurde.


## 6.5.4

### en

* Adds the supplier order number to the supplier order PDF filename.
* Fixes a bug that could prevent the order status from being updated when sending orders via the api.
* Fixes a bug in the bin location selection list.

### de

* Fügt die Bestellnummer in den Namen der PDF-Dateien von Lieferantenbestellung ein.
* Behebt einen Fehler, der unter Umständen verhinderte, dass der Bestellstatus beim Versenden von Bestellungen über die API angepasst wurde.
* Behebt einen Fehler in der Lagerplatzauswahlliste.


## 6.5.3

### en

* Fixes a bug that could prevent stock from being moved via API under certain circumstances.
* Updates the compatibility constraint to the plugin "Dreischild Set Artikel-Konfigurator".

### de

* Behebt einen Fehler, der unter Umständen verhinderte, dass Bestand via API umgelagert werden konnte.
* Aktualisiert den Kompatibilitätshinweis zum Plugin "Dreischild Set Artikel-Konfigurator".


## 6.5.2

### en

* Fixes a bug that caused the column "Pending quantity" to show incorrect values for canceled supplier order positions in the "Supply" tab.
* Updates the compatibility constraint to the plugin "Dreischild Set Artikel-Konfigurator".

### de

* Behebt einen Fehler, der dazu führte, dass die Spalte "Offene Menge" im "Lieferungen" Tab falsche Werte angezeigt hat wenn die Lieferanten-Bestellung storniert wurde.
* Aktualisiert den Kompatibilitätshinweis zum Plugin "Dreischild Set Artikel-Konfigurator".


## 6.5.1

### en

* Fixes a bug that caused the suggested purchase order quantity for supplier order positions to be 0 if no minimum purchase quantity was defined for the corresponding supplier item assignment.

### de

* Behebt einen Fehler, der dazu führte, dass die vorgeschlagene Bestellmenge für Lieferantenbestellpositionen 0 war, wenn für die entsprechende Lieferantenzuordnung des Artikels keine Mindestabnahmenmenge definiert war.


## 6.5.0

### en

* Groups suppliers while choosing one in the _Create order_ window of the ordering in order of assigned and other suppliers and marks the default supplier.
* Fixes a bug that may have prevented the "Shipped" values from being set for an order item when the order was marked as "Completely delivered".
* Fixes a bug that could cause stock entries to be written with a stock change amount of zero.
* Fixes a bug that prevented the "suggested reorder quantity" column from being sorted in supplier orders.
* Fixes a bug that prevented more than 25 bin location from being displayed in bin location selection lists.
* Fixes a bug which could cause the barcode label printing to fail to render the barcode under certain circumstances.
* Fixes a bug that prevented a cancellation invoice from being generated when a net or tax-exempt order used a shipping method with a tax rate of 0%.

### de

* Gruppiert bei der Auswahl von Lieferanten im Fenster _Bestellung erstellen_ des Bestellwesens diese nach zugewiesenen und weiteren Lieferanten und markiert den Standard-Lieferanten.
* Behebt einen Fehler, der unter Umständen verhinderte, dass für eine Bestellposition die "Versendet"-Werte gesetzt wurden, wenn die Bestellung als "Komplett ausgeliefert" markiert wurde.
* Behebt einen Fehler, der dazu führen konnte, dass Bestandseinträge mit einer Bestandsänderung von Null geschrieben wurden.
* Behebt einen Fehler, der verhinderte, dass sich die Spalte "Vorschlag" bei Lieferantenbestellungen sortieren ließ.
* Behebt einen Fehler, der verhinderte, dass mehr als 25 Lagerplätze in Lagerplatzauswahllisten angezeigt wurden.
* Behebt einen Fehler, der unter bestimmten Umständen dazu führen konnte, dass der Barcode-Etikettendruck den Barcode nicht darstellen konnte.
* Behebt einen Fehler, der verhinderte, dass eine Stornorechung erzeugt werden konnte, wenn eine Netto- oder Steuerfrei-Bestellung eine Versandart mit einem Steuersatz von 0% verwendete.


## 6.4.0

### en

* Enables compatibility to Shopware 5.6.
* Adds the possibility of assigning several order items to a supplier at the same time in supplier ordering.
* Fixes a bug that could have caused the mail window to not open on order status changes.
* Adds an incompatibility warning for plugin "Blauband E-Mails (EKS)".

### de

* Stellt die Kompatibilität zu Shopware 5.6 her.
* Fügt die Möglichkeit hinzu, im Bestellwesen mehreren Bestellpositionen gleichzeitig einen Lieferanten zuzweisen.
* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass sich das Mail-Fenster bei Änderungen des Auftragsstatus nicht öffnet.
* Fügt einen Inkompatibilitätshinweis für das Plugin "Blauband E-Mails (EKS)" hinzu.


## 6.3.0

### en

* Highlights non-standard suppliers in the _Create order_ window of the ordering now with a flash.
* Adds the ability to save supplier assignments and purchase prices for an item while creating a supplier order.
* Fixes a bug that caused the shop owner's email address to always be used when sending invoices by email.
* REST API requests are now only logged if they were sent by one of the Pickware apps and/or request a resource that is part of the Pickware API.

### de

* Hebt Nicht-Standard-Lieferanten im Fenster _Bestellung erstellen_ des Bestellwesens nun mit einem Blitz hervor.
* Fügt die Möglichkeit hinzu Lieferantenzuweisungen und Einkaufspreise für einen Artikel innerhalb des Bestellwesen zu speichern.
* Behebt einen Fehler, der dazu führte, dass beim E-Mail-Versand von Rechnungen immer die Adresse des Shopbetreibers verwendet wurde.
* Ab sofort werden nur noch solche REST-API-Requests geloggt, die von einer der Pickware Apps gesendet wurden und/order eine Ressource anfragen, die Teil der Pickware API ist.


## 6.2.2

### en

* Marks the Plugin "Dreischild Set Artikel-Konfigurator" as incompatible.
* Fixes a bug that caused rows to be displayed in the wrong style in the position cancellation window under certain circumstances.
* Fixes a bug which could cause the "Turnover by main shop categories" report to show incorrect results for gross turnover.
* Fixes a bug which made it possible to edit the inStock in the variant overview from articles from Shopware 5.5 onwards.
* Fixes a bug that could have caused the invoice number to appear as cancellation invoice number on the cancellation invoice preview.
* Articles are now called `items` in the english translation.

### de

* Markiert das Plugin "Dreischild Set Artikel-Konfigurator" als inkompatibel.
* Behebt einen Fehler, der unter Umständen dazu führte, dass Einträge im Fenster "Positionen stornieren" in der falschen Formatierung angezeigt wurden.
* Behebt einen Fehler, der unter Umständen dazu führte, dass die Auswertung "Umsatz nach Hauptshop-Kategorien" fehlerhafte Ergebnisse für Bruttoumsätze lieferte.
* Behebt einen Fehler, der dazu führte, dass die Bearbeitung des Lagerbestands in der Variantenübersicht von Artikel ab Shopware 5.5 möglich war.
* Behebt einen Fehler, der unter Umständen dazu führte, dass die Rechnungsnummer als Stornorechnungsnummer auf der Stornorechnungsvorschau angezeigt wurde.
* Artikel heißen nun `items` in der englischen Übersetztung.


## 6.2.1

### en

* Fixes a bug which prevented the cancellation invoice from being created on Shopware versions below 5.5 in some cases.
* Fixes a bug which caused positive sums to be shown with two minus signs instead of none on cancellation invoices.

### de

* Behebt einen Fehler, der in Shopware-Versionen vor 5.5 unter bestimmten Umständen verhinderte, dass eine Stornorechnung erzeugt werden konnte.
* Behebt einen Fehler, der dazu führte, dass positive Summen auf Teilstornorechnungen mit doppeltem Minuszeichen statt ohne Vorzeichen dargestellt wurden.


## 6.2.0

### en

* Moves the backend stock-take functionality from _Shopware WMS powered by Pickware_ into this plugin.
* Fixes a bug which could cause stock entry inconsistencies when stock entries for the same item were written at the exact same time by different users.
* Fixes a bug which prevented the supplier order creation window from loading correctly.
* Fixes a bug which could cause the "Turnover by main shop categories" report to show incorrect results.

### de

* Verschiebt die Backend-Inventurfunktion aus _Shopware WMS powered by Pickware_ in dieses Plugin.
* Behebt einen Fehler, durch den es zu fehlerhaften Bestandseinträgen kommen konnte, wenn Bestände von mehreren Benutzern gleichzeitig für den gleichen Artikel verändert wurden.
* Behebt einen Fehler, durch den es unter Umständen zu einem Fehler beim Öffnen des Fensters zum Erstellen einer Lieferantenbestellung kommen konnte.
* Behebt einen Fehler, der unter Umständen dazu führte, dass die Auswertung "Umsatz nach Hauptshop-Kategorien" fehlerhafte Ergebnisse lieferte.


## 6.1.6

### en

* Fixes a bug that could cause the counters _Quantity_ or _Shipped_ within an order to be reset if an order was saved after a change in order status to _Canceled/Rejected_ or _Completely delivered_ without reopening it in the meantime.

### de

* Behebt einen Fehler, der unter Umständen dazu führte, dass die Zähler _Anzahl_ bzw. _Versendet_ innerhalb einer Bestellung zurückgesetzt wurden, wenn eine Bestellung im Anschluss an eine Bestellstatusänderung auf _Storniert/Abgelehnt_ bzw. _Komplett ausgeliefert_, erneut gespeichert wurde, ohne diese zwischenzeitlich neu zu öffnen.


## 6.1.5

### en

* Fixes a bug that prevented the cancellation of a return shipment if no `TaxID` was set for any order item.

### de

* Behebt einen Fehler, der verhinderte, dass die Stornierung einer Rücksendung durchgeführt werden konnte, wenn für eine Bestellposition keine `TaxID` gesetzt war.


## 6.1.4

### en

**Note:** After installing this update, users of _Shopware WMS powered by Pickware_ will have to update the plugin to version 5.9.0 or later.

* Fixes a bug that caused stock to be cleared twice for orders marked as shipped using the Pickware Picking app if Shopware ERP powered by Pickware version 6.1.3 and Shopware WMS powered by Pickware version < 5.9.0 were installed.

### de

**Hinweis:** Nach der Installation dieser Version müssen Nutzer von _Shopware WMS powered by Pickware_ auf Version 5.9.0 (oder neuer) des Plugins aktualisieren.

* Behebt einen Fehler, der dazu führte, dass für Bestellungen, die per Pickware Versand-App als versendet markiert wurden, Bestand doppelt ausgebucht wurde, sofern Shopware ERP powered by Pickware in Version 6.1.3 und Shopware WMS powered by Pickware in einer Version < 5.9.0 installiert war.


## 6.1.3

### en

* Fixed a bug that prevented documents from being sent from the _Order Details_ window when the status of the order was changed shortly before.

### de

* Behebt einen Fehler, der verhinderte, dass Dokumende aus dem Fenster _Bestellungs-Details_ heraus versendet werden konnte, wenn kurz davor der Status der Bestellung verändert wurde.


## 6.1.2

### en

* Fixes a bug that prevented the order list from being sortable by the _Returns_ column.

### de

* Behebt einen Fehler, der verhinderte, dass sich die Bestellliste nach der Spalte "Retouren" sortieren ließ.


## 6.1.1

### en

* Fixes a bug which caused error messages to be logged when using Import/Export profiles other than the ones shipped with this plugin.
* Fixes a bug which prevented the item numbers of added line items from being printed on the cancellation invoice.

### de

* Behebt einen Fehler, der dazu führte, dass bei der Verwendung von Import/Export-Profilen, die nicht zu Shopware ERP gehören, unnötige Fehlermeldungen protokolliert wurden.
* Behebt einen Fehler, der verhinderte, dass die Artikelnummern von Zusatzpositionen auf die Stornorechnung gedruckt wurden.


## 6.1.0

### en

* Adds new REST API endpoints for updating item stock.
* Adds new REST API endpoints for marking orders or order positions as shipped and clearing the associated stock from the warehouse.
* Fixes a bug which caused REST API requests to fail under certain circumstances.
* Fixes a bug which prevented existing documents from loading correctly when sending emails from the _Documents_ tab of an order.
* Fixes a bug which prevented Shopware versions prior to 5.5 from opening the _Send an email to the customer_ dialog window when changing the order status or payment status in the backend.

### de

* Fügt der REST-API neue Endpunkte zum Ändern von Artikelbeständen hinzu.
* Fügt der REST-API neue Endpunkte hinzu, mit deren Hilfe Bestellungen oder Bestellpositonen als versandt markiert und die zugehörigen Bestände ausgebucht werden können.
* Behebt einen Fehler, der unter bestimmten Umständen zu Fehlern bei der Verarbeitung von REST API Requests führen konnte.
* Behebt einen Fehler, durch den bestehende Dokumente beim E-Mail-Versand aus dem Dokumente-Tab einer Bestellung, nicht korrekt geladen wurden.
* Behebt einen Fehler, durch den in Shopware Versionen vor 5.5 der Dialog zum E-Mail-Versand beim Wechsel des Bestell- oder Zahlungsstatus im Backend nicht geöffnet wurde.


## 6.0.0

### en

**Note:** After installing this update, users of _Shopware WMS powered by Pickware_ will have to update to version 5.8.0  or later and users of _Shopware POS powered by Pickware_ will have to update to version 5.5.0 or later.

* Allows creating and processing return shipments from within the Shopware backend. Adds a new window _Customers → Return shipments_ which provides an overview for all return shipments. Further information on this topic can be found in [the user manual](http://www.pickware.de/dokumentation/erp/heading=h.nvemklde7qlq).
* Allows creating printable barcode labels for items and bin locations from the backend.
* Now allows creating supplier orders in currencies other than the default currency.
* Adds new REST API endpoints for creating, updating and deleting warehouses and bin locations.
* Adds a packing unit field to the item supplier mappings, which improves the suggested order quantity for items which are packaged in quantities other than 1.
* Adds a button which removes multiple items from the right pane of the supplier order window.
* Allows pre-selecting items for barcode label printing from the supplier order based on the ordered quantity.
* When updating the order status while creating shipping labels in batch mode, stocks are now cleared correctly and the "shipped" counter is incremented.
* Removes the column `availableStock` from the Import / Export profile `viison_pickware_erp_article_stocks_relative`.
* Adds a new column "sales" to the analytics report "Gross Profit".
* Fixes a bug that caused the same position to be added to a supplier order multiple times when the supplier order was edited concurrently.
* The tab "Suppliers" is now enabled right after saving a new item.
* Fixes a bug that caused unrelated stock entries to be shown in the "Stock" tab after saving an item.
* Fixes a bug that prevented the mapping to the "unknown" bin location from being removed when its last stock reservation was cleared.
* Fixes a bug which prevented the parameter `useNumberAsId` of the Shopware REST API's `/api/orders` resource from being respected.
* Fixes a bug which prevented the order status in the stock overview from being translated.

### de

**Hinweis:** Nach der Installation dieser Version müssen Nutzer von _Shopware WMS powered by Pickware_ auf Version 5.8.0  (oder neuer) und Nutzer von _Shopware POS powered by Pickware_ auf Version 5.5.0 (oder neuer) des jeweiligen Plugins aktualisieren.

* Ermöglicht das Anlegen und Verarbeiten von Retouren aus dem Shopware-Backend. Fügt im Menü _Kunden → Retouren_ eine neue _Retourenübersicht_ hinzu. Weitere Informationen hierzu finden Sie in [der Dokumentation](http://www.pickware.de/dokumentation/erp/heading=h.nvemklde7qlq).
* Ermöglicht es, im Backend Artikel- und Lagerplatzetiketten zu erstellen, die auf Etikettenbögen gedruckt werden können.
* Ermöglicht das Erstellen von Lieferantenbestellungen in Fremdwährungen.
* Fügt der REST-API neue Endpunkte für das Erstellen, Bearbeiten und Löschen von Lagern und Lagerplätzen hinzu.
* Fügt den Artikel-Lieferanten-Zuordnungen im Lieferantenbestellwesen ein Feld "Verpackungseinheit" hinzu, um für Artikel mit von 1 abweichenden Packungsgrößen korrekte Nachbestellmengen vorschlagen zu können.
* Ermöglicht es, in Lieferantenbestellungen die nachbestellte Menge eines Artikels für den Artikeletikettendruck vorzumerken.
* Fügt der Ansicht "Bestellung erstellen" im Lieferantenbestellwesen einen Button hinzu, mit dem mehrere Artikel aus der Liste der zur Bestellung vorgemerkten Artikel entfernt werden können.
* Beim Ändern des Bestellstatus über die Versandetiketten-Stapelverarbeitung werden jetzt korrekt Bestände ausgebucht und der Zähler "versendet" erhöht.
* Entfernt die Spalte `availableStock` aus dem Import / Export-Profil `viison_pickware_erp_article_stocks_relative`.
* Fügt der Auswertung "Rohertrag" die Spalte "Verkäufe" hinzu.
* Behebt einen Fehler, der unter Umständen dazu führte, dass für einen Artikel mehrere Positionen zu einer Lieferantenbestellung hinzugefügt wurden, falls die Lieferantenbestellung gleichzeitig von mehreren Benutzern bearbeitet wurde.
* Das Tab "Lieferanten" kann jetzt unmittelbar nach dem Speichern eines neuen Artikels geöffnet werden.
* Behebt einen Fehler, der dazu führte, dass nach dem Speichern eines Artikels die falschen Bestandseinträge im Tab "Bestand" angezeigt wurden.
* Behebt einen Fehler, der verhinderte, dass die Zuweisung eines Artikels zum leeren, unbekannten Lagerplatz aufgelöst wurde, sobald dessen letzte Bestandsreservierung entfernt wurde.
* Behebt einen Fehler, durch den der Parameter `useNumberAsId` der Shopware REST API-Ressource `/api/orders` nicht korrekt beachtet wurde.
* Behebt einen Fehler, durch den der Bestellstatus in der Bestandsübersicht nicht übersetzt wurde.


## 5.5.1

### en

* Fixes a bug that could have caused variant articles without generated variants to be assigned incorrect suppliers.
* Fixes a bug that could have caused incorrect "Incoming" values to be displayed in the supplier purchase order process.
* Fixes a bug when creating supplier orders that disabled the buttons to add items with negative stock or stock below minimum stock when the plugin "Drop-Shipping powered by Pickware" was installed.
* Fixes a bug that caused the pagination of the results of the analysis "Stock Movements" not to work.
* Improves validation of CSV input of the product import ("Import/Export" plugin).
* Fixes a bug that caused the generation of bin location codes to fail if the code pattern contained certain special characters.
* Increases the timeout value for analysis. This avoids an communication error for longer running analysis.

### de

* Behebt einen Fehler, der unter Umständen dafür sorgte, dass Varianten-Artikel ohne generierte Varianten falschen Lieferanten zugewiesen wurden.
* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass im Lieferantenbestellwesen falsche Werte in der Spalte "Nachbestellt" angezeigt wurden.
* Behebt einen Fehler beim Erzeugen von Lieferantenbestellungen, der die Buttons zum Hinzufügen von Artikeln mit negativem Bestand oder Bestand unter Mindestbestand deaktivierte, wenn das Plugin "Drop-Shipping powered by Pickware" installiert war.
* Behebt einen Fehler, der verursachte, dass die Paginierung der Ergebnisse der Analyse "Warenbewegungen" nicht funktionierte.
* Verbessert die Validierung der CSV-Eingabedatei im Artikelimport ("Import/Export" Plugin).
* Behebt einen Fehler, der dazu führte, dass das Generieren von Lagerplatzcodes fehlschlug, wenn das Codemuster bestimmte Sonderzeichen enthielt.
* Erhöht den Timeout-Wert für Auswertungen. Dies vermeidet den Fehler "Communication error" bei länger dauernden Auswertungen.


## 5.5.0

### en

* Adds the report "Stock Movements" to the backend analytics.
* Marks the Plugin "Mbdus Artikel Im-/Export" as incompatible.
* The Backend stock initialization is now done in batches, which prevents problems with long-running stock initialization causing timeout errors.
* Fixes a bug that could have caused a faulty CSV export of rated stock.
* Fixes a bug that caused the wrong document box value to be shown on pick lists.

### de

* Fügt die Auswertung "Warenbewegungen" hinzu.
* Markiert das Plugin "Mbdus Artikel Im-/Export" als inkompatibel.
* Die Backend Warenbestand-Initialisierung wird nun in kleineren Verarbeitungsblöcken durchgeführt, um Timeout-Fehler zu verhindern.
* Behebt einen Fehler, der unter Umständen zu einem fehlerhaften CSV-Export im bewerteten Warenbestand führen konnte.
* Behebt einen Fehler, der dafür sorgte, dass ein falscher Inhalt eines Dokumenten-Elements auf Picklisten angezeigt wurde.


## 5.4.2

### en

* Fixes a bug that prevented the creation of supplier orders, if items were deleted from prepared supplier order.
* Fixes a bug that prevented the CSV export of supplier orders, if they contained items whose corresponding products have been deleted.

### de

* Behebt einen Fehler, der die Erstellung neuer Lieferantenbestellungen verhinderte, falls Positionen, welche Teil einer vorbereiteten Lieferantenbestellung waren, gelöscht wurden.
* Behebt einen Fehler, der den CSV-Export von Lieferantenbestellungen verhinderte, wenn diese Position enthielten, deren zugehörige Produkte gelöscht wurden.


## 5.4.1

### en

* Adds a compatibility warning for versions of Shopware WMS lower than 5.4.0 and versions of Shopware POS lower than 5.2.3.
* Improves the supplier order document preview.

### de

* Fügt eine Kompatibilitätswarnung für Shopware WMS-Versionen vor 5.4.0 und Shopware POS-Versionen vor 5.2.3 hinzu.
* Verbessert die Vorschau von Lieferantenbestellscheinen.


## 5.4.0

### en

* Only shows Shopware's built-in "email document" button in an order's _Documents_ tab when Shopware 5.5 is used.
* Removes the incompatibility warning for plugin "GiroCheckout Payment" starting with version 3.1.2.
* Improves performance of the export profile "viison_pickware_erp_article_suppliers" and "viison_pickware_erp_article_stock_limits".
* Improves performance of Shopware ERP powered by Pickware analytics.
* Fixes a bug where the document path was not resolved correctly when Shopware was installed via Composer.
* Fixes a bug that caused the order and payment status to not be translated in the order list of an item.

### de

* Zeigt ab Shopware 5.5 im Tab _Dokumente_ einer Bestellung nur noch den Shopware-eigenen Button zum Versenden von Dokumenten an.
* Entfernt den Inkompatibilitätshinweis für das Plugin "GiroCheckout Payment" ab Version 3.1.2.
* Verbessert die Ausführungszeit des Exportprofils "viison_pickware_erp_article_suppliers" und "viison_pickware_erp_article_stock_limits".
* Verbessert die Ausführungszeit von Statistiken von Shopware ERP powered by Pickware.
* Behebt ein Problem, durch das der Dokumentenpfad nicht korrekt aufgelöst wurde, wenn Shopware per Composer installiert wurde.
* Behebt ein Problem, das dazu führte, dass unter Umständen in der Bestellliste zu einem Artikel der Bestell- und Zahlungsstatus nicht übersetzt wurden.


## 5.3.2

### en

* Fixes a bug that led to stock errors in rare cases when carrying out an inventory.

### de

* Behebt einen Fehler, der beim Durchführen einer Inventur in seltenen Fällen zu Bestandsfehlern führte.


## 5.3.1

### en

* Improves the compatibility with Shopware 5.5.2 and above.
* Adds an incompatibility warning for plugin "GiroCheckout Payment".
* Improves the collapsing of warehouse stocks in the warehouse stock field set.
* Fixes a bug that caused the calculation for stock in admission to be wrong when displaying supplier orders of an article.
* Analytics for "Article Sales" now uses the currency symbol from the standard currency.
* Fixes a bug that could have prevented products from correctly being suggested for reordering, if the plugin "Drop-Shipping powered by Pickware" was installed.
* If an order is marked as shipped via the status "Completely delivered", the status of all shipped order items is now set to "Completed".

### de

* Verbessert die Kompatibilität mit Shopware 5.5.2 und höher.
* Fügt einen Inkompatibilitätshinweis für das Plugin "GiroCheckout Payment" hinzu.
* Verbessert das Ein- und Ausklappen der Lagerbestände in der Artikeldetailansicht.
* Behebt einen Fehler, der dazu führte, dass die Menge im Zulauf eines Artikels nicht korrekt berechnet wurde.
* Die Auswertung "Artikel nach Umsätzen" nutzt nun das Währungssymbol der Standardwährung.
* Behebt ein Fehler, der unter Umständen dazu führte, dass Artikel nicht korrekt zur Nachbestellung vorgeschlagen wurden, wenn das Plugin "Drop-Shipping powered by Pickware" installiert war.
* Wird eine Bestellung über den Status "Komplett ausgeliefert" als versendet makiert, wird nun der Status aller versendeten Positionen auf "Komplett abgeschlossen" gesetzt.


## 5.3.0

### en

* Adds the possibility to change the target warehouse of a supplier order while its status is **not yet** "partially delivered" or "completely delivered".
* Fixes a bug that prevented the stock initialization from being performed when creating new products via the REST API batch endpoint.

### de

* Fügt die Möglichkeit hinzu, das Ziellager einer Lieferantenbestellung zu ändern, solange diese **noch nicht** im Status "Teilweise ausgeliefert" oder "Komplett ausgeliefert" ist.
* Behebt einen Fehler, der dazu führte, dass beim Anlegen von Artikeln über die Stapelverarbeitung der REST-API die Bestände nicht initialisiert wurden.


## 5.2.1

### en

* Fixes a bug that prevented the assignment of manufacturer articles to suppliers in some cases.

### de

* Behebt einen Fehler, durch den das Zuordnen von Herstellerartikeln zu Lieferanten unter bestimmten Umständen verhindert wurde.


## 5.2.0

### en

* Improves usability of some of the plugin's backend components.
* Adds demo data to provide a preview for the document type "pick list".
* Fixes a bug that occurred when updating the available stock ("inStock") of a product which is not stock-managed via the Shopware REST API.
* Fixes a bug that prevented plain-text supplier order emails from being displayed correctly by email clients.
* Fixes a bug that prevented supplier documents from being downloaded if the supplier name contained a comma.

### de

* Verbessert die Benutzbarkeit einiger Backend-Komponenten des Plugins.
* Fügt Demodaten für die Vorschau des Dokuments "Pickliste" hinzu.
* Behebt einen Fehler, der bei der Aktualisierung des verfügbaren Bestandes ("inStock") eines nicht bestandsgeführten Artikels über die Shopware-REST-API auftrat.
* Behebt einen Fehler, der zu Anzeigefehlern bei im Textformat versendeten Lieferantenbestellungs-E-Mails führte.
* Behebt einen Fehler, durch den Lieferantenbestelldokumente nicht heruntergeladen werden konnten, falls der Name des Lieferanten ein Komma enthielt.


## 5.1.0

### en

* Adds the columns "Available stock", "Physical stock" and "Total price" to the column selection in the detail window of a supplier order.
* Fixes an error that might have prevented an order from being deleted.

### de

* Ergänzt die Spaltenauswahl im Detailfenster einer Lieferantenbestellung um die Spalten "Verfügbarer Lagerbestand", "Physischer Lagerbestand" und "Gesamtpreis".
* Behebt einen Fehler, der unter Umständen verhinderte, dass eine Bestellung gelöscht werden konnte.


## 5.0.2

### en

* Fixes a bug that could prevent the stock of a bin location from being reduced.

### de

* Behebt einen Fehler der unter Umständen verhinderte, dass der Bestand eines Lagerplatzes reduziert werden konnte.


## 5.0.1

### en

* Fixes a bug which prevented the additional variant text to be displayed when assigning an article variant to a supplier.
* Fixes an error that could occur during update to version 5.0.0 under rare circumstances.

### de

* Behebt einen Problem, durch das der Variantentext von Variantenartikeln nicht angezeigt wurde, sobald man ihn einem Lieferanten zuordnet.
* Behebt einen Fehler, der unter seltenen Umständen beim Update auf Version 5.0.0 auftreten konnte.


## 5.0.0

### en

**Note:** Users of _Shopware WMS powered by Pickware_, _Shopware POS powered by Pickware_ and _fiskaltrust for Shopware POS_ will have to update those plugins as well as the apps _Pickware POS_, _Pickware Picking_ and _Pickware Inventory_ to the latest 5.0.0 release.

* Improves compatibility with Shopware 5.5.
* Adds support for generating pick-list documents for orders.
* Adds the missing header for the supplier item number in the csv exports of supplier orders.
* Adds a search field to the "selected articles" ("article assignment" tab) of the supplier detail window.
* Fixes a problem with sending HTML-based supplier emails.
* Fixes a bug which prevented more than a single email attachment from being displayed in the mailer dialogue.
* Fixes an issue which prevented suppliers which lacked an email address from being imported.
* Fixes a problem that could cause the wrong physical stock to be displayed in the "Stock overview" diagram for days with multiple stock entries.
* Fixes an issue where Quick overview and Statistical overview show different amounts of new users/customers.

### de

**Hinweis:** Nutzer von _Shopware WMS powered by Pickware_, _Shopware POS powered by Pickware_ und _fiskaltrust für Shopware POS_ müssen nach dem Update auf diese Version ebenfalls diese Plugins, sowie die Apps _Pickware POS_, _Pickware Versand_ und _Pickware Lager_ auf die jeweilige Version 5.0.0 aktualisieren.

* Verbessert die Kompatibilität mit Shopware 5.5.
* Fügt die Möglichkeit hinzu, Picklisten-Dokumente für Bestellungen zu erzeugen.
* Fügt die Spaltenüberschrift für die Spalte Lieferanten-Artikelnummer im CSV-Export einer Lieferantenbestellung hinzu.
* Erweitert den Bereich "Ausgewählte Artikel" im Tab "Artikelzuordnung" des Lieferanten-Detail-Fensters um ein Eingabefeld zur Suche innerhalb der Artikelliste.
* Behebt ein Problem beim Versand von HTML-basierten Lieferanten-E-Mails.
* Behebt ein Problem, durch das im E-Mail-Versand-Dialog maximal ein Anhang angezeigt wurde.
* Behebt ein Problem, durch das Lieferanten ohne E-Mail-Adresse nicht importiert werden konnten.
* Behebt ein Darstellungsproblem, durch das für einen Tag mit mehreren Bestandseinträgen im Diagramm der Bestandsübersicht unter Umständen der falsche physische Bestand angezeigt wurde.
* Behebt ein Darstellungsproblem, durch das in der Schnell-Übersicht und in der Auswertungsübersicht eine unterschiedliche Anzahl an neuen Benutzern/Kunden angezeigt wurde.


## 4.3.2

### en

* Fixes a bug that could prevent the stock of a bin location from being reduced.

### de

* Behebt einen Fehler der unter Umständen verhinderte, dass der Bestand eines Lagerplatzes reduziert werden konnte.


## 4.3.1

### en

* Fixes an issue in the calculation of the minimum and target stock values in the stock overview.

### de

* Behebt einen Darstellungsfehler bei der Berechnung der Mindest- und Sollbestände in der Bestandsübersicht.


## 4.3.0

### en

* Adds a “minimum stock” and “target stock” per warehouse for each item.
* Adds a new Import/Export profile to edit stock limits (minimum and target stock) per CSV.
* Improves the order proposals of the ordering system. The order proposals are now calculated taking into account the warehouse selection and the target stock of the items.
* Improves the usability of the ordering system.
* Extends the stock overview by a display of the current stock levels of the selected item. For each item, the stocks and stock limits for each warehouse can now be adjusted directly, without having to switch to the item details window.

### de

* Erweitert die Lagerverwaltung der Artikel um einen „Mindestbestand“ und „Sollbestand“ je Lager.
* Fügt ein neues Import/Export-Profil zum Bearbeiten von Bestandsgrenzen (Mindest- und Sollbestand) per CSV hinzu.
* Verbessert die Bestellvorschläge im Bestellwesen. Die Bestellvorschläge werden nun unter Berücksichtigung der Lagerauswahl und des Sollbestands der Artikel berechnet.
* Verbessert die Benutzerfreundlichkeit des Bestellwesens.
* Erweitert die Bestandsübersicht um eine Darstellung der aktuellen Lagerbestände des ausgewählten Artikels. Pro Artikel können nun die physischen Bestände und Bestandsgrenzen pro Lager eingesehen und direkt angepasst werden, ohne in das Artikeldetails-Fenster wechseln zu müssen.


## 4.2.1

### en

* Fixes an issue that caused some items which were initialized prior to version 4.1.0 to be shown as still requiring initialization.

### de

* Behebt ein Problem, durch das einige vor dem Update auf Version 4.1.0 initialisierte Artikel irrtümlicherweise als noch nicht initialisiert angezeigt wurden.


## 4.2.0

### en

**Note:** This version of Shopware ERP powered by Pickware is compatible to Shopware 5.5.0. Please do not yet update your shop to Shopware 5.5.0 if you also use Shopware WMS and/or Shopware POS powered by Pickware, as these are not yet compatible to Shopware 5.5.0.

* The plugin is now compatible to Shopware 5.5.
* Adds a comment to the supplier order document template which explains how to display item images on the former.
* Fixes the double negative sign in the stock field set in the article details window.
* Fixes cases of incorrect gross/net labeling of purchase price sum in rated stocks overview.
* Fixes an issue that caused some items which were initialized prior to version 4.1.0 to be shown as still requiring initialization.

### de

**Hinweis:** Diese Version von Shopware ERP powered by Pickware ist mit Shopware 5.5.0 kompatibel. Bitte aktualisieren Sie Ihren Shop noch nicht auf Shopware 5.5.0, falls Sie zusätzlich die Plugins Shopware WMS und/oder Shopware POS powered by Pickware einsetzen, da diese aktuell noch nicht kompatibel zu Shopware 5.5.0 sind.

* Das Plugin ist nun kompatibel mit Shopware 5.5.
* Fügt dem Lieferantenbestellungs-Dokumententemplate einen Kommentar hinzu, der erklärt, wie man Artikelbilder im Dokument einbinden kann.
* Entfernt das doppelte negative Vorzeichen im Bestandsfeld im Artikeldetail-Fenster.
* Korrigiert die fehlerhafte brutto/netto-Bezeichnung der Einkaufspreissumme im Fenster "Bewerteter Warenbestand".
* Behebt ein Problem, durch das einige vor dem Update auf Version 4.1.0 initialisierte Artikel irrtümlicherweise als noch nicht initialisiert angezeigt wurden.


## 4.1.5

### en

* Fixes a problem that occured when importing suppliers with supplier numbers.

### de

* Behebt einen Fehler, der beim Import von Lieferanten mit Lieferantennummern auftreten konnte.


## 4.1.4

### en

* Fixes a problem that caused a stock initialization error when duplicating items.

### de

* Behebt einen Fehler bei der automatischen Bestandsinitialisierung von duplizierten Artikeln.


## 4.1.3

### en

* Fixes a problem that prevented newly-created items from being initialized automatically.
* Fixes a problem that prevented items from being initialized individually from the stock initialization window.
* Fixes a problem that prevented item variants from being generated successfully.
* Fixes a problem that could occur when importing suppliers using the console command `sw:importexport:import --profile viison_pickware_erp_suppliers`.
* Fixes a bug that could have caused the Shopware backend to not be available anymore under some circumstances.

### de

* Behebt einen Fehler, durch den neu angelegte Artikel nicht mehr automatisch initialisiert wurden.
* Behebt einen Fehler, durch den Artikel im Bestandsinitialisierungsdialog nicht mehr einzeln initialisiert werden konnten.
* Behebt einen Fehler, der dazu führte, dass für Artikel keine Varianten mehr generiert werden konnten.
* Behebt einen Fehler, der beim Import von Lieferanten mit dem Konsolenbefehl `sw:importexport:import --profile viison_pickware_erp_suppliers` auftreten konnte.
* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass das Backend nicht mehr erreichbar war.


## 4.1.2

### en

* Fixes an error that might have occurred while updating.

### de

* Behebt einen Fehler, der unter Umständen während des Updates auftrat.


## 4.1.1

### en

* Fixes an error that might have occurred while updating.

### de

* Behebt einen Fehler, der unter Umständen während des Updates auftrat.


## 4.1.0

### en

**Note:** Starting with this version of the plugin, at least version 4.0.13 is required to be able to install updates. If you currently use an older version, you need to manually download at least version 4.0.13 from the Shopware Community Store and install it first. Afterwards you can update the plugin again to the latest version.

**Note:** The column "supplierNumber" replaces the column "supplierId" within the *Shopware Import/Export* profile "Pickware suppliers".

* Improves the usability of several Pickware modules across the Shopware backend.
* Adds an editable, unique number to suppliers that e.g. simplifies the identification of suppliers when using the "Shopware Import/Export" plugin.
* Improves compatibility with Shopware 5.5.
* Fixes a bug that lead to partially deleted articles being displayed in the stock initialization.
* Fixes a bug that could possibly prevent the pagination of the rated stock report from working correctly.
* Fixes a bug that could possible prevent assigning manufacturers to suppliers.

### de

**Hinweis:** Um das Plugin auf diese Version zu aktualisieren, muss mindestens Version 4.0.13 des Plugins installiert sein. Wenn Sie noch eine ältere Version verwenden, müssen Sie das Plugin zunächst manuell über ein Download aus Ihrem Shopware Account auf mindestens Version 4.0.13 aktualisieren. Anschließend kann das Update auf diese Version wie gewohnt über den Plugin-Manager durchgeführt werden.

**Hinweis:** Im "Pickware Lieferanten"-Profil für das Plugin "Shopware Import/Export" wird die Spalte "supplierId" durch eine neue Spalte "supplierNumber" ersetzt.

* Verbessert die Bedienbarkeit vieler Pickware-Module im Shopware-Backend.
* Fügt den Lieferanten eine editierbare, aber dennoch einzigartige Lieferantennummer hinzu, die unter anderem die Zuordnung von Lieferanten bei Verwendung des Plugins "Shopware Import/Export" erleichtert.
* Verbessert die Kompatibilität mit Shopware 5.5.
* Behebt einen Fehler, der dazu führte, dass teilweise gelöschte Artikel in der Bestandsinitialisierung angezeigt wurden.
* Behebt einen Fehler, der unter Umständen dazu führte, dass die Paginierung des bewerteten Warenbestands nicht korrekt funktionierte.
* Behebt einen Fehler, der unter Umständen dazu führte, dass einem Lieferanten keine Hersteller zugewiesen werden konnten.


## 4.0.32

### en

* Makes stock initialization more robust in cases where items were picked using “Shopware WMS powered by Pickware” before the initialization was performed, but were not yet shipped.
* Fixes a bug that lead to wrong stocks when the stock of the warehouse, that was selected upon changing the status of an order to "completely delivered" or order details' "shipped" values, is not available for purchase.

### de

* Erhöht die Robustheit der Initialisierung für den Fall, dass sich die Artikel während der Initialisierung in der Kommissionierung von “Shopware WMS powered by Pickware” befanden.
* Behebt einen Fehler, der zu falschen Beständen führte, wenn beim Ändern des Status einer Bestellung auf "komplett ausgeliefert" oder der "Versendet"-Werte einer Bestellposition ein Lager ausgewählt wurde, dessen Bestand nicht zum Verkauf zur Verfügung steht.


## 4.0.31

### en

* Fixes a bug that lead to wrong stocks for products that have been picked using "Shopware WMS powered by Pickware" prior to their initialization.
* Fixes a bug that prevented the purchase price strategy (net/gross) from being changed.
* Fixes missing text snippets in the Pickware news widget.

### de

* Behebt einen Fehler, der zu falschen Beständen führte, wenn Artikel vor ihrer Initialisierung mit "Shopware WMS powered by Pickware" kommissioniert wurden.
* Behebt einen Fehler, der das Ändern der Einkaufspreis-Strategie (netto/brutto) verhinderte.
* Korrigiert fehlende Textbausteine im Pickware News Widget.


## 4.0.30

### en

* Fixes a bug in the sum calculation of articles in the "Article Sales" analytics.
* Fixes a bug that caused supplier order documents to be always generated in the same language.

### de

* Behebt einen Fehler in der Summenberechnung von Artikeln in der Analyse "Artikel nach Umsätzen".
* Behebt einen Fehler, der dazu führte, dass Lieferantenbestelldokumente immer in der gleichen Sprache erzeugt wurden.


## 4.0.29

### en

* Fixes a problem that caused mail creation to fail for language sub shops in Shopware version 5.4.3.

### de

* Behebt ein Problem bei dem Erstellen von E-Mails für Sprach-Sub-Shops in Shopware 5.4.3.

## 4.0.28

### en

* Fixes a bug that caused the sending of emails in the supplier order management to fail in Shopware version 5.2.

### de

* Behebt einen Fehler, der dazu führte, dass der E-Mail-Versand im Lieferantenbestellwesen in Shopware Version 5.2 fehlschlug.


## 4.0.27

### en

* Adds an identifier for unknown bin locations when exporting stocks.
* Fixes a bug that caused the sending of emails in the supplier order management to fail.

### de

* Fügt eine Kennzeichnung von unbekannten Lagerplätzen beim Export von Beständen hinzu.
* Behebt einen Fehler, der dazu führte, dass der E-Mail-Versand im Lieferantenbestellwesen fehlschlug.


## 4.0.26

### en

* Fixes an error that might have occurred when creating return shipments in the Inventory App (Pickware Mobile only).

### de

* Behebt einen Fehler, der unter Umständen beim Erstellen von Rücksendungen in der Lager App auftrat (nur Pickware Mobile).


## 4.0.25

### en

* Fixes the error "Unable to update, got message: Class 'Shopware\CustomModels\ImportExport\Profile' does not exist", which occurred during the update step of the previous version.

### de

* Behebt den Fehler "Unable to update, got message: Class 'Shopware\CustomModels\ImportExport\Profile' does not exist", der während der Aktualisierung auf die vorherige Version auftreten konnte.


## 4.0.24

### en

* Fixes a bug in the import/export profile for suppliers.
* Fixes the CSV export of supplier orders.

### de

* Behebt einen Fehler im Import/Export Profil für Lieferanten.
* Behebt einen Fehler, der beim CSV-Export von Lieferantenbestellungen auftrat.


## 4.0.23

### en

* Improves main category selection in the "Turnover by main shop categories" analytics.
* Fixes a bug which might caused the supplier article number to be stored incorrectly.
* Fixes a bug that could falsely remove a warehouse from the warehouse overview in the article details when changing its default bin location.

### de

* Verbessert die Kategorieauswahl in der Auswertung "Umsatz nach Hauptshop-Kategorien".
* Behebt einen Fehler, der dazu führen konnte, dass die Lieferanten-Artikel-Nummer nicht korrekt gespeichert wurde.
* Behebt einen Fehler, der dazu führte, dass nach Änderung des Standardlagerplatzes das entsprechende Lager nicht mehr in der Übersicht angezeigt wurde.


## 4.0.22

### en

* Invoices that are sent to the invoice archive now use the same filename as the invoices sent to the customer.
* Fixes a problem that prevented inventory errors from being displayed for items that have never been ordered before.
* Fixes a problem that prevented the default bin location from being deselected on article variant level.
* Improves the selection of translation and templates for supplier documents by assigning a sub shop to each supplier instead of a language.

### de

* Rechnungen, welche per E-Mail an das Rechnungsarchiv gesendet werden, haben nun den gleichen Dateiname wie jene, die an den Kunden gesendet werden.
* Behebt ein Problem, welches verhinderte, dass für einen Artikel Bestandsfehler angezeigt wurden, wenn dieser noch nie bestellt wurde.
* Behebt ein Problem, das dazu führte, dass der Standardlagerplatz nicht auf Variantenebene entfernt werden konnte.
* Verbessert die Auswahl von Übersetzungen und Templates für Lieferantendokumente, indem Lieferanten ein Subshop anstelle einer Sprache zugeordnet wird.


## 4.0.21

### en

* Fixes an error that occurred when opening the Shopware backend.

### de

* Behebt einen Fehler, der beim Öffnen des Shopware Backends auftrat.


## 4.0.20

### en

* Fixes a problem which caused the supplier order number range to be reset on reinstall.
* Fixes a problem which caused missing stock entries for newly added positions with a positive shipped value.
* Fixes a bug that may have prevented the total amounts of an order from being updated after chaging the order status to "cancelled / rejected".

### de

* Behebt ein Problem, das dazu führte, dass der Nummernkreis für Lieferantenbestellungen bei der Neuinstallation zurückgesetzt wurde.
* Behebt ein Problem, das dazu führte, dass Bestandseinträge nicht korrekt geschrieben wurden, wenn eine neue Position mit einem positiven "Versendet"-Wert erstellt wurde.
* Behebt einen Fehler, der dazu führte, dass der Gesamtbetrag einer Bestellung nicht aktualisiert wurde, wenn der Status der Bestellung auf "Storniert / Abgelehnt" geändert wurde.


## 4.0.19

### en

* Fixes a problem that causes the backend to be unavailable when the main shop language is set to a non-European language.

### de

* Behebt ein Problem, das dazu führt, dass das Backend nicht erreichbar ist, wenn die Sprache des Hauptshops auf eine außereuropäische Sprache eingestellt ist.


## 4.0.18

### en

* Fixes a bug that prevented setting the "on sale" flag on item variants.

### de

* Behebt einen Fehler, durch den es nicht möglich war, die Option "Abverkauf" in Artikelvarianten zu aktivieren.


## 4.0.17

### en

* Improves compatibility with Shopware 5.4.

### de

* Verbessert die Kompatibilität mit Shopware 5.4.


## 4.0.16

### en

* Fixes a bug that prevented orders from being saved when client and server use different time zones.

### de

* Behebt ein Problem, das dazu führte, dass sich Bestellungen nicht speichern ließen, wenn Server und Client verschiedene Zeitzonen verwenden.


## 4.0.15

### en

* Fixes a bug that caused the message "The order has been changed in the meantime" to be displayed in situations where that was not actually the case.
* The summary of a supplier order in the supplier order management module now also contains the total number of items contained in the order.
* Improves compatibility with Shopware 5.4.

### de

* Behebt einen Fehler, der dazu führte, dass die Meldung "Die Bestellung wurde zwischenzeitlich geändert." manchmal auch dann angezeigt wurde, wenn die Bestellung nur von einem Benutzer bearbeitet wurde.
* Die Zusammenfassung einer Lieferantenbestellung im Bestellwesen enthält nun zusätzlich die Gesamtanzahl der enthaltenen Positionen.
* Verbessert die Kompatibilität mit Shopware 5.4.


## 4.0.14

### en

* Fixes a problem that prevented orders from being created via the Shopware REST API.

### de

* Behebt einen Fehler, durch den die Bestellanlage über die Shopware-REST-API verhindert wurde.


## 4.0.13

### en

* Stock entries that didn't change the physical stock (e.g. relocations) are now displayed without purchase price.
* Improves the dialogs that are shown when manually changing the order status to "Completely delivered" or "Cancelled / Rejected".
* The available stock is now adjusted correctly when deleting a (partially) shipped order.
* Simplifies the packaging unit shown in PDF or CSV exports of supplier orders.

### de

* Bestandseinträge, die den Warenbestand nicht verändert haben (z.B. Umlagerungen), werden nun ohne Einkaufspreis angezeigt.
* Verbessert die Abfragen beim manuellen Ändern des Bestellstatus auf "Komplett ausgeliefert" oder "Storniert / Abgelehnt".
* Ab sofort wird der verfügbare Lagerbestand korrekt angepasst, wenn eine (teilweise) versandte Bestellung gelöscht wird.
* Vereinfacht die im PDF- und CSV-Export von Lieferantenbestellungen angezeigte Verpackungseinheit.


## 4.0.12

### en

* Fixes an error that caused the order overwrite protection to always prevent saving orders from the backend when running on a 32 bit operating system.
* Fixes an error that caused the buttons for sending and deleting order documents to be displayed twice since Shopware 5.3.4.

### de

* Behebt einen Fehler, durch den auf Servern, die noch mit einem 32-bit-Betriebssystem arbeiten, alle Änderungen an Bestellungen aus dem Backend verhindert wurden.
* Behebt einen Fehler, der ab Shopware 5.3.4 dazu führte, dass im Tab "Dokumente" einer Bestellung die Buttons zum Versenden und Löschen von Dokumenten doppelt angezeigt wurden.


## 4.0.11

### en

* Prevents orders from being overwritten with outdated information from the backend if they were modified by another user (this includes using the Picking App) in the meantime.
* Improves the precision of the displayed gross profit in the "Gross Profit" report.

### de

* Verhindert, dass Bestellungen im Backend mit veralteten Daten überspeichert werden können, wenn sie zwischenzeitlich von einem anderen Benutzer (auch über die Versand-App) geändert wurden.
* Erhöht die Genauigkeit der Rohertragsanzeige in der Auswertung "Rohertrag".


## 4.0.10

### en

* Due to compatibility issues, reverts the change that prevented orders from being overwritten from the backend.

### de

* Macht das Blockieren von Bestelländerungen aus dem Backend rückgängig, da sich mit der aktuellen Lösung Kompatibilitätsprobleme ergeben haben.


## 4.0.9

### en

* Fixes a compatibility problem with Pickware POS that prevented orders from being created.
* Fixes a compatibility problem during the update to version 4.0.7 and 4.0.8, which occurred for some users with older MySQL versions.

### de

* Behebt ein Kompatbilitätsproblem mit Pickware POS, durch das das Anlegen von POS-Bestellungen verhindert wurde.
* Behebt ein Kompatibilitätsproblem, das beim Update auf Version 4.0.7 oder 4.0.8 in einigen Fällen bei Benutzern mit veralteten Versionen von MySQL auftreten konnte.


## 4.0.8

### en

* Fixes a compatibility problem during the update to version 4.0.7, which occurred for some users with older MySQL versions.

### de

* Behebt ein Kompatibilitätsproblem, das beim Update auf Version 4.0.7 in einigen Fällen bei Benutzern mit veralteten Versionen von MySQL auftreten konnte.


## 4.0.7

### en

* Fixes a problem that caused the last purchase price of an item to be set to 0 (EUR/CHF/GBP/...) in the backend after a stock removal or stock transfer process.
* Prevents orders from being overwritten with outdated information from the backend if they were modified by another user (this includes using the Picking App) in the meantime.
* Fixes an error that caused the name of the main shop to be shown instead of the name of the sub shop when using the template expression `{config name=shopName}` in email templates.

### de

* Behebt ein Problem, das dazu führte, dass nach einer Auslagerung oder einer Umlagerung der letzte Einkaufpreis eines Artikels im Backend auf 0 (EUR/CHF/GBP/...) gesetzt wurde.
* Verhindert, dass Bestellungen im Backend mit veralteten Daten überspeichert werden können, wenn sie zwischenzeitlich von einem anderen Benutzer (auch über die Versand-App) geändert wurden.
* Behebt einen Fehler, der dazu führte, dass bei der Verwendung des Template-Ausdrucks `{config name=shopName}` in E-Mail-Vorlagen der Name des Hauptshops statt des Subshops verwendet wurde.


## 4.0.6

### en

* Employs a workaround for compatibility issues caused by the Shopware Security plugin, which occurred during the installation and update process of Shopware ERP powered by Pickware.
* Removes an obsolete profile for importing/exporting stocks.

### de

* Behebt durch das Shopware Security Plugin verursachte Kompatibilitätsprobleme, die während der Installation und dem Update von Shopware ERP powered by Pickware auftraten.
* Entfernt ein veraltetes Profil für den Import/Export von Beständen.


## 4.0.5

### en

* Fixes a bug in the CSV export of article orders that caused the header row to not match the actual exported data.
* Fixes a bug that caused a stock change alert to be displayed when adding a new position to an existing order in the backend.
* Fixes a bug that caused bin location mappings to be dissolved when importing zero stocks in some cases.

### de

* Behebt einen Fehler, der dazu führte, dass im CSV-Export von Bestellungen eines Artikels die Kopfzeile nicht mit den Daten übereinstimmte.
* Behebt einen Fehler, der dazu führte, dass ein Auslagerungshinweis angezeigt wurde, sobald einer bestehenden Bestellung im Backend eine neue Position hinzugefügt wurde.
* Behebt einen Fehler, der beim Import von absoluten Beständen dazu führte, dass Lagerplatzzuweisungen in manchen Fällen fehlerhaft aufgelöst wurden.


## 4.0.4

### en

* Improves the compatibility with Pickware Mobile and Pickware POS.

### de

* Verbessert die Kompatibilität mit Pickware Mobile und Pickware POS.


## 4.0.3

### en

* Changing the order status to "Cancelled" or "Rejected" does not change the physical stock anymore.
* The "shipped" quantity of an order item is no longer set to zero when changing the order status to "Cancelled" or "Rejected".
* Fixes several bugs in the list of changed bin locations of a product's stock list.
* Fixes a bug in the relative stock import/export profile that prevented negative changes of the physical stock from being imported.

### de

* Beim Ändern des Bestellstatus auf "Storniert" oder "Abgelehnt" wird der physische Bestand jetzt nicht mehr angepasst.
* Die "versandte" Menge einer Bestellposition wird ab sofort nicht mehr genullt, wenn der Status der Bestellung auf "Storniert" oder "Abgelehnt" gesetzt wird.
* Behebt einige Fehler in der Anzeige der geänderten Lagerplätze in der Bestandsliste eines Artikels.
* Behebt einen Fehler im Profil für den relativen Import/Export von Beständen, der den Import von negativen Bestandsänderungen verhinderte.


## 4.0.2

### en

* Fixes a bug that caused the article stock export to fail in Shopware 5.2
* Fixes a calculation error regarding PickwarePOS returns in the "Gross profit" report.

### de

* Behebt einen Fehler beim Lagerbestand-Export in Shopware 5.2
* Behebt einen Fehler bei der Berechnung von Rückgaben am PickwarePOS in der Auswertung "Rohertrag"


## 4.0.1

### en

* Fix an issue that occurred when importing stocks using the Import/Export module with empty values for the column `availableStock`.

### de

* Behebt einen Fehler beim Importieren von Beständen über das Import-/Export-Modul, wenn die Spalte `availableStock` leer gelassen wird.


## 4.0.0

### en

* Adds support for chaotic warehousing (this means that one product can be stored on multiple bin locations within the same warehouse).
* Updates the stock editing dialog, which now supports relocating stock between different warehouses in a single step.
* Adds an Import/Export profile which allows importing relative stock changes.
* Adds delivery date to supplier order document context variables.

### de

* Ermöglicht die chaotische Lagerhaltung (ein Artikel kann  auf mehreren Lagerplätzen innerhalb eines Lagers liegen).
* Der Dialog zum Ändern der Bestände wurde überarbeitet und unterstützt jetzt das Umlagern zwischen Lagern in einem Schritt.
* Fügt ein neues Import/Export-Profil zum Importieren von Bestandsänderungen via CSV hinzu.
* Fügt das Lieferdatum als Kontext-Variable in Lieferanten-Bestelldokumenten hinzu.


## 3.2.54

### en

* Fixes a bug in the calculation of the total purchase price of the gross profit report.

### de

* Behebt einen Fehler in der Berechnung des Gesamteinkaufpreises in der Auswertung "Rohertrag".


## 3.2.53

### en

* Fixes a bug in the CSV export of the "article sales" report.
* Improves the english translation of the "article sales" report.
* Improves the "gross profit" report performance.
* Fixed a compatibility issue with the plugin "SetArticles" in the "gross profit" report.

### de

* Behebt einen Fehler im CSV Export der Auswertung "Artikel nach Umsätzen".
* Verbessert die Englische Übersetzung der Auswertung "Artikel nach Umsätzen".
* Verbessert die Performance der Auswertung "Rohertrag".
* Behebt ein Kompatibilitätsproblem mit dem Plugin "Stücklisten" in der Auswertung "Rohertrag".


## 3.2.52

### en

* Fixes a bug in the calculation of the net purchase values in the gross profit report, where gross purchase prices
are used in the shop.

### de

* Behebt einen Fehler in der Berechnung des Netto-Wareneinkauf-Werts in der Auswertung “Rohertrag”, sofern die
Einkaufspreise im Shop brutto gepflegt werden.


## 3.2.51

### en

* Fixes a bug in the calculation of the gross purchase amount in the gross profit report.
* Fixes a bug in the plugin's uninstallation process in Shopware 5.3.

### de

* Behebt einen Fehler in der Berechnung des Brutto-Wareneinkauf-Werts in der Auswertung "Rohertrag".
* Behebt einen Fehler bei der Deinstallation des Plugins in Shopware 5.3.


## 3.2.50

### en

* Improves the English translation of the plugin configuration.
* Fixes the pagination of the gross profit report.

### de

* Verbessert die Englische Übersetzung der Pluginkonfiguration.
* Behebt einen Fehler in der seitenweisen Anzeige der Ergebnismenge in der Auswertung "Rohertrag".


## 3.2.49

### en

* Fixes an error that occurred when opening the article edit window.

### de

* Behebt einen Fehler, der beim Öffnen des Artikeldetailfensters auftrat.


## 3.2.48

### en

* Fixes an error that occurred when opening the article edit window.

### de

* Behebt einen Fehler, der beim Öffnen des Artikeldetailfensters auftrat.


## 3.2.47

### en

* Improves the UI of the stock overview.
* Improves the performance of the supplier order management.

### de

* Verbessert die Darstellung der Bestandsübersicht.
* Verbessert die Geschwindigkeit des Lieferantenbestellwesens.


## 3.2.46

### en

* Adds an English translation for the plugin configuration.
* Fixes a problem that prevented supplier orders from being created successfully.

### de

* Fügt Englische Übersetzungen der Pluginkonfiguration hinzu.
* Behebt ein Problem bei der Erstellung von Lieferantenbestellungen.


## 3.2.45

### en

* Fixes an error that appeared when opening the supplier management view.
* Removes minimum stock values from articles that are not stock-managed.

### de

* Behebt einen Fehler beim Öffnen des Lieferantenbestellwesens.
* Entfernt die Lager-Mindestbestände von Artikeln, die nicht bestandsgeführt sind.


## 3.2.44

### en

* Fixes a bug in the sorting of the supplier article number column of the article assignment view within the supplier management window.

### de

* Behebt einen Fehler in der Sortierung der Spalte "Lieferanten Artikel-Nr." im Tab "Artikelzuordnung" des "Lieferanten bearbeiten" Fensters.


## 3.2.43

### en

**Attention:** This release is incompatible with Pickware Mobile versions prior to 1.1.42. Users of Pickware Mobile must update it to the newest version after installing this update.

* Now supports individual article numbers per supplier.
* Adds missing thumbnail quality settings to supplier order media album.
* Improves compatibility with Pickware POS.

### de

**Achtung:** Diese Version ist mit Pickware Mobile-Versionen vor 1.1.42 inkompatibel. Benutzer von Pickware Mobile müssen daher nach der Installation dieses Updates ebenfalls Pickware Mobile auf die neueste Version aktualisieren.

* Unterstützt jetzt individuelle Artikelnummern je Lieferant.
* Ergänzt die fehlende Konfiguration der Thumbnail Qualität des Medien Albums zum Lieferantenbestellwesen.
* Verbessert die Kompatibilität mit Pickware POS.


## 3.2.42

### en

* Fixes several UI bugs in the backend extensions.

### de

* Behebt einige Anzeigefehler in den Backend-Erweiterungen.


## 3.2.41

### en

* Improves marking articles as "not stock managed" via the REST API.

### de

* Verbessert das Markieren eines Artikels als "nicht bestandsgeführt" über die REST API.


## 3.2.40

### en

* It is now possible to mark an article or variant as "not stock managed" via the REST API by changing the `viisonNotRelevantForStockManager` attribute.

### de

* Es ist nun möglich durch Ändern des `viisonNotRelevantForStockManager` Attributs über die REST API einen Artikel bzw. eine Variante als "nicht bestandsgeführt" zu markieren.


## 3.2.39

### en

* Fixes a Smarty caching error that occurred when opening the shopware backend

### de

* Behebt einen Fehler im Zusammenhang mit Caching in Smarty, der beim Öffnen des shopware Backends auftrat


## 3.2.38

### en

* Improves the stock initialization.

### de

* Verbessert die Bestandsinitialisierung.


## 3.2.37

### en

* Improves the usability of the (partial-)cancellation dialog of the order detail window.
* Adds the option to add a "dummy" positon, when canceling order positions via the (partial-)cancellation dialog of the order detail window.
* Adds a new column "tax" to the (partial-)cancellation dialog of the order detail window.

### de

* Verbessert die Darstellung und Usability des (Teil-)Storno-Dialogs des Bestell-Detail Fensters.
* Erlaubt das Hinzufügen einer "Dummy" Position beim Stornieren von Bestellpositionen mittels des (Teil-)Storno-Dialogs des Bestell-Detail Fensters.
* Fügt dem (Teil-)Storno-Dialog des Bestell-Detail Fensters eine neue Spalte "Steuer" hinzu.


## 3.2.36

### en

* Fixes several UI bugs in the backend extensions.

### de

* Behebt einige Anzeigefehler in den Backend-Erweiterungen.


## 3.2.35

### en

* When editing the available stock it is now saved right away
* Improves the cancellation of order positions so that the window is not closed and reopened anymore
* Fixes the editing of purchase prices in the article stock history
* Fixes a UI glitch in the supplier order creation/editing
* Contains preparations for Pickware Mobile v1.1.27

### de

* Nach dem Bearbeiten des verfügbaren Lagerbestandes wird dieser nun direkt gespeichert
* Verbessert die Stornierung von Bestellposition, sodass das Fenster nicht mehr geschlossen und erneut geöffnet wird
* Behebt einen Fehler der das Bearbeiten von Einkaufspreisen in der Artikelbestandshistory verhinderte
* Behebt einen Darstellungsfehler im Lieferantenbestellwesen
* Enthält Vorbereitungen auf Pickware Mobile v1.1.27


## 3.2.34

### en

* Prevents potential errors in the stock caused by a CSV import after the stock of the imported article has already been initialized.
* Fixes a bug that occurred when loading the stock list in the backend articles module.
* Fixes a bug that might have resulted in an empty order list in the backend articles module.

### de

* Verhindert mögliche Bestandsfehler durch den CSV-Import, nachdem der Bestand des importierten Artikels bereits initialisiert wurde.
* Behebt einen Fehler, der beim Laden der Bestandsliste im Artikel auftrat.
* Behebt einen Fehler, der unter Umständen dazu führte, dass die Liste der Bestellungen eines Artikels nicht geladen wurde.


## 3.2.33

### en

* Fixes an error that was causing wrong results in the rated stock view in some cases.
* Improves performance when loading the list of supplier orders.
* Stock is now automatically initialized after importing articles and article variants from CSV.
* Stock is now automatically initialized after creating articles and article variants over the REST API.
* Fixes a number of issues which may have caused stock errors when generating article variants.

### de

* Behebt die Ursache für in einigen Situationen auftretende falsche Werte im bewerteten Warenbestand.
* Verbessert die Geschwindigkeit beim Laden der Lieferantenbestellungen.
* Beim CSV-Import von Artikeln und Varianten werden die Bestände nun automatisch initialisiert.
* Beim Erstellen von Artikel und Varianten über die REST API werden die Bestände nun automatisch initialisiert.
* Behebt mehrere Fehler beim Generieren von Varianten, die zu falschen Beständen führen konnten.


## 3.2.32

### en

* Fixes an error that might have occurred while reserving stock
* Fixes an error during the plugin update occurring in some MySQL versions

### de

* Behebt einen Fehler der unter Umständen beim Reservieren von Beständen auftrat
* Behebt einen Fehler der unter manchen MySQL Versionen während des Updates auftrat


## 3.2.31

### en

* When changing the order status or an order item's shipped value in the backend, it is now possible to choose the warehouse, whose stock will be changed by cancelling/shipping the order items
* Fixes an error that might have occurred while reserving stock

### de

* Ändert man den Status einer Bestellung oder die versendete Anzahl einer Bestellposition im Backend, ist es nun möglich das Lager auszuwählen, dessen Bestand durch das Stornieren/Versenden der Positionen verändert wird
* Behebt einen Fehler der unter Umständen beim Reservieren von Beständen auftrat


## 3.2.30

### en

* Fixes an error that might have occurred during the update to version 3.2.29

### de

* Behebt einen Fehler, der möglicherweise während des Updates auf Version 3.2.29 auftrat


## 3.2.29

### en

* The article names on supplier order documents are now correctly translated to the supplier's language, if available
* Improves the UI of the stock overview
* Fixes a bug that resulted in partially duplicated stocks when duplicating variants
* Fixes a bug that might have caused the email sender to be set more than once when sending documents via email

### de

* Die Artikelnamen auf Dokumente zu Lieferanten-Bestellungen werden nun korrekt in die Sprache des Lieferanten übersetzt, sofern verfügbar
* Verbessert die Darstellung in der Bestandsübersicht
* Behebt einen Fehler der dazu führte, dass beim Duplizieren von Varianten die Bestände teilweise ebenfalls kopiert wurden
* Behebt einen Fehler der unter Umständen dazu führte, dass beim Dokumentenversand per E-Mail der Absender mehrfach gesetzt wurde


## 3.2.28

### en

* Improves the performance and stability of the supplier order window
* Emails to suppliers are now translated correctly
* Adds the full article name to exports of stocks/bin locations and supplier article detail assignments ("Shopware Import/Export" plugin)
* Fixes an error that occurred when importing the stock/bin location of an article, whose stock has not been initialized before ("Shopware Import/Export" plugin)
* Fixes a bug that might have caused article's stock to be initialized more than once

### de

* Verbessert die Leistung und Stabilität des Lieferanten-Bestellwesens
* E-Mails an Lieferanten werden nun korrekt übersetzt
* Fügt den vollständigen Artikelnamen zu Exporten von Lagerbeständen/Lagerplätzen und Lieferanten-Artikel-Zuordnungen hinzu ("Shopware Import/Export" Plugin)
* Behebt einen Fehler, der beim Bestands-/ Lagerplatz-Import von Artikel auftrat, deren Bestand vorher nicht initialisiert wurde ("Shopware Import/Export" Plugin)
* Behebt einen Fehler, der unter Umständen dazu führte, dass der Bestand des gleichen Artikels mehrmals initialisiert wurde


## 3.2.27

### en

* Enables usage of HTML email templates in supplier orders.
* Fixes a bug related to assigning outgoing stock entries to initialization stock entries.
* Fixes an out-of-memory issue that occurs during large rated stock exports.

### de

* Unterstützt HTML E-Mail-Templates in Lieferanten-Bestellungen.
* Behebt ein Problem bei der Verknüpfung von ausgehenden Bestandseinträgen mit Initialisierungseinträgen.
* Behebt ein Out-of-Memory-Problem beim Export des bewerteten Warenbestands.


## 3.2.26

### en

* Provide usage of html email templates as well as custom sender name and address

### de

* Verwende HTML E-Mail Templates, sowie individuelle Senderinformationen, sofern konfiguriert


## 3.2.25

### en

* Adds a plugin compatibility warning
* The amount of entries on list dialogs is now configurable

### de

* Fügt eine Plugin-Kompatibilitätswarnung hinzu
* Die Anzahl der Einträge für Listen-Dialoge ist jetzt konfigurierbar


## 3.2.24

### en

* Fixes a bug in the stock overview that caused many articles to be marked as problems, although their stocks were correct

### de

* Behebt einen Fehler in der Bestandsübersicht, der dazu führte, dass einige Artikel als Probleme markiert wurden, obwohl ihre Bestände korrekt waren


## 3.2.23

### en

* Fixes a bug in the supplier order document causing positions to be hidden, if a custom position limit is configured
* Fixes a bug in the order cancellation, which caused the whole order to be cancelled, if only shipping costs should have been cancelled

### de

* Behebt einen Fehler im Lieferantenbestellungs-Dokument, der dazu führte, dass manche Positions nicht angezeigt wurden, wenn ein spezielles Positionen-Limit konfiguriert ist
* Behebt einen Fehler in der Stornierung von Bestellungen, der dazu führte, dass die gesamte Bestellung storniert wurde, wenn nur die Versandkosten storniert werden sollten


## 3.2.22

### en

* Fixes some display bugs in the supplier order document
* Fixes a bug in the stock overview that prevent the article list from being sorted by sales

### de

* Behebt einige Darstellungsfehler im Lieferantenbestellungs-Dokument
* Behebt einen Fehler in der Bestandsübersicht, der dazu führte, dass die Artikelliste nicht nach Verkäufen sortiert werden konnte


## 3.2.21

### en

* Improves the performance of the custom Pickware export profiles for many articles

### de

* Verbessert die Leistung beim Export mit den Pickware Profilen für viele Artikel


## 3.2.20

### en

* Improves the handling of articles that are marked as "not relvant for stock managing"
* Improves the compatibility with Pickware POS

### de

* Verbessert die Handhabung von Artikeln, die als "nicht bestandsgeführt" markiert sind
* Verbessert die Kompatiblität mit Pickware POS


## 3.2.19

### en

* Fixes an issue that prevented article main variant attributes from being copied to generated variants.
* Fixes a number of UI glitches when editing non-stock-managed articles.
* Fixes number format glitches in analytics.
* Fixes customer number in supplier order document.

### de

* Behebt einen Fehler beim Kopieren von Attributen der Artikel-Hauptvariante in neu generierte Artikelvarianten.
* Behebt einige kleine UI-Fehler bei der Bearbeitung von nicht bestandsgeführten Artikeln.
* Behebt einige falsche Zahlenformate in den Auswertungen.
* Behebt Fehler mit der Kundennummer in Lieferantenbestellungs-Dokumenten.


## 3.2.18

### en

* The fields contained in a supplier order CSV export are now configurable

### de

* Die Felder, die in einem CSV-Export einer Lieferantenbestellung enthalten sind, sind nun konfigurierbar


## 3.2.17

### en

* Fixes a problem when generating article variants on Shopware versions below 5.2.13.

### de

* Behebt einen Problem bei der Generierung von Artikelvarianten mit Shopware-Versionen unter 5.2.13.


## 3.2.16

### en

* Fixes a problem that was causing stock errors after generating article variants.

### de

* Behebt einen Problem mit fehlerhaften Beständen nach der Generierung von Artikelvarianten.


## 3.2.15

### en

* Fixes a sporadically occurring error during the plugin update

### de

* Behebt einen sporadisch auftretenden Fehler im Plugin-Update


## 3.2.14

### en

* Fixes a script error when generating article variants.

### de

* Behebt ein Javascript-Problem beim Generieren von Artikelvarianten.


## 3.2.13

### en

* Changes the article number column name in the import and export of stocks and supplier article detail assignments from "orderNumber" to "articleNumber"
* Fixes an error that occurred when loading the document template configuration

### de

* Ändert den Namen der Artikelnummer-Spalten im Im- und Export von Beständen sowie Lieferanten-Artikel-Zuordnungen von "orderNumber" zu "articleNumber"
* Behebt einen Fehler beim Laden der Dokumenten-Template Einstellungen


## 3.2.12

### en

* Hides irrelevant stock management functionality for articles that are not stock-managed
* Improves the performance when loading the stock initialization for many articles in the shop

### de

* Versteckt Bestandsfunktionen für nicht bestandsgeführte Artikel
* Verbessert die Geschwindigkeit beim Laden der Bestandsinitialisierung bei vielen Artikeln im Shop


## 3.2.11

### en

* Improves the naming of documents in email attachments
* Adds the missing variant texts to the stock initialization and analytics
* From now on the destination warehouse is displayed on the supplier order documents


### de

* Verbessert die Benennung von Dokumenten in Email-Anhängen
* Fügt den fehlenden Variantentext zur Bestandsinitialisierung und zu den Auswertungen hinzu
* Ab sofort wird das Ziellager standardmäßig auf den Dokumenten von Lieferantenbestellungen angezeigt


## 3.2.10

### en

* Makes the supplier order document template more customizable

### de

* Verbessert die Anpassbarkeit des Dokumenten-Template von Lieferantenbestellungen


## 3.2.9

### en

* Fixes a bug in the supplier order document template that caused a wrong document title

### de

* Behebt einen Fehler, der dafür sorgte, dass im Dokumenten-Template von Lieferantenbestellungen ein falscher Title angezeigt wurde


## 3.2.8

### en

* Adds the import and export of stocks, bin locations, suppliers and supplier article detail assignments (requires the "Shopware Import/Export" plugin)
* Adds a configurable document template for supplier orders
* Improves the sort order in the article stock list
* Fixes a bug that caused the stock of an article to be copied to generated variants
* Fixes a bug in the 'inStock' value update in batch processing mode
* Fixes a bug in the cancellation of shipping costs of net orders
* Fixes an error that prevented the deletion of warehouses

### de

* Fügt den Im- und Export von Beständen, Lagerplätzen, Lieferanten und Lieferanten-Artikel-Zuordnungen hinzu (erfordert das "Shopware Import/Export" Plugin)
* Fügt ein konfigurierbares und erweiterbares Dokumententemplate für Lieferantenbestellungen hinzu
* Verbessert die Sortierreihenfolge in der Artikel-Bestandsliste
* Behebt einen Fehler beim Erstellen von Varianten, der dazu führte, dass die Varianten den gleichen Bestand hatten wie die Hauptvariante
* Behebt einen Fehler in der Aktualisierung des Verfügbarkeitszählers im Stapelverarbeitungsmodus
* Behebt einen Fehler bei der Stornierung von Versandkosten einer Netto-Bestellung
* Behebt einen Fehler, der das Löschen von Lagern verhinderte


## 3.2.7

### en

* Improves the stability of the plugin update

### de

* Verbessert die Stabilität des Plugin-Updates


## 3.2.6

### en

* Fixes a sporadically occurring error in the plugin update

### de

* Behebt einen sporadisch auftretenden Fehler im Plugin-Update


## 3.2.5

### en

* Fixes a potentially occurring inconsistency in the stock data

### de

* Behebt eine eventuell auftretende Inkonsistenz in den Bestandsdaten


## 3.2.4

### en

* Update of the "About Pickware" menu
* Fixes a bug in the automatic canceling of shipping costs, when the user changes the order status to "canceled / rejected".

### de

* Überarbeitung des "Über Pickware"-Menüs
* Behebt einen Fehler bei der automatischen Stornierung von Versandkosten, wenn der Bestellstatus auf "Storniert / Abgelehnt" geändert wird

## 3.2.3

### en

* Improves the usablity of the stock planning
* Fixes a bug in the stock initialization that caused the stocks to be greater than displayed
* Fixes a bug that caused duplicated articles to not show up in any of the Pickware apps
* Fixes the order cancellation to re-calculate the order amount correctly

### de

* Verbessert die Benutzbarbeit der Bestandsplanung
* Behebt einen Fehler in der Bestandsinitialisierung der dazu führte, dass die Bestände nach der Initialisierung größer waren als angezeigt
* Behebt einen Fehler der dazu führte, dass duplizierte Artikel nicht in den Pickware Apps angezeigt wurden
* Behebt einen Fehler in der Stornierung von Bestellung, sodass der Bestellwert nun wieder korrekt berechnet wird


## 3.2.2

### en

* Fixes some problems that may lead to situations where the number of default warehouses is not exactly 1.

### de

* Behebt einige Probleme, die dazu führen konnten dass nicht genau ein Standardlager existiert.


## 3.2.1

### en

* Adds an incompatibility warning for plugin "Lagerbestand Protokoll"
* Disable sorting in stock overview
* Assign new articles to the default storage location to make them available in the apps

### de

* Fügt einen Inkompatibilitätshinweis für das Plugin "Lagerbestand Protokoll" hinzu
* Verhindert Fehler beim Sortieren der Lagerbestandsübersicht
* Ordnet neue Artikel dem Standardlagerplatz zu, damit sie in den Apps angezeigt werden

## 3.2.0

### en

* Adds report "stock turnover rate".
* Fixes a view error with low resolution displays.
* Fixes a problem when editing multiple article variants.
* Fixes timeout issues faced when changing the bin location of articles.
* Fixes an issue when migrating from older versions.

### de

* Fügt die Auswertung "Lagerumschlagshäufigkeit" hinzu.
* Behebt einen Anzeigefehler bei niedrigauflösenden Displays.
* Behebt ein Problem beim Bearbeiten von mehreren Artikelvarianten nacheinander.
* Behebt ein Timeout-Problem bei der Änderung des Lagerplatzes von Artikeln.
* Behebt ein Problem bei der Migration von älteren Versionen.


## 3.1.4

### en

* Fixes a problem when stocking newly-created articles.

### de

* Behebt einen Fehler bei der Einlagerung neu erstellter Artikel.


## 3.1.3

### en

* Fixes a problem when stocking articles and assigning storage bins.
* Fixes a problem when exporting the rated stock.

### de

* Behebt einen Fehler bei der Einlagerung und Lagerplatzänderung von Artikeln.
* Behebt einen Fehler beim Export des bewerteten Warenbestands


## 3.1.2

### en

* Fixes a problem when saving new articles.

### de

* Behebt einen Fehler beim Speichern neu angelegter Artikel.


## 3.1.1

### en

* Fixes the upgrade error "Integrity constraint violation: 1022 Can't write; duplicate key in table [...]".

### de

* Behebt den Fehler bei Aktualisierung "Integrity constraint violation: 1022 Can't write; duplicate key in table [...]".


## 3.1.0

### en

* It is now possible to create additional warehouses using the warehouse management (Items > Warehouse > Warehouse management)
* Bin locations can now be generated in the warehouse management using a customizable schema
* When sending an order document by email the document titles are now translated and use the respective document identifier (e.g. invoice number) instead of the order number, if possible
* The email used for sending invoice documents to the archive now uses a customizable template

### de

* Ab sofort ist es möglich über die Lagerverwaltung (Artikel > Lager > Lagerverwaltung) zusätzliche Lager anzulegen
* Es ist nun möglich in der Lagerverwaltung Lagerplätze anhand eines anpassbaren Schemas zu generieren
* Beim Senden von Bestelldokumenten per E-Mail werden die Dateinamane ab sofort übersetzt und enthalten die entsprechende Dokumentennummer (z.B. Rechnungsnummer) anstelle der Bestellnummer, falls möglich
* E-Mails, die an das Rechnungsarchiv geschickt werden, verwenden nun ein anpassbares Template


## 3.0.29

### en

* Fixes the adjustment of the physical stock upon importing an article, in case the property "instock" is not set by the import

### de

* Behebt die fehlerhafte Aktualisierung des Lagerbestands beim Import eines Artikels, falls kein neuer Wert für das Feld "instock" gesetzt wird


## 3.0.28

### en

* Fixes a broken resource file
* Improves the compatibility with PHP 7

### de

* Repariert eine kaputte Ressource-Datei
* Verbessert die Kompatibilität mit PHP 7


## 3.0.27

### en

* Improves the compatibility with other Pickware plugins

### de

* Verbessert die Kompatibilität mit anderen Pickware plugins
