<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Commands;

use Shopware\Commands\ShopwareCommand;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockInitialization;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * CLI command for stock initialization
 */
class InitializeAllArticlesCommand extends ShopwareCommand
{
    /**
     * Setup the command name, arguments and help text.
     */
    public function configure()
    {
        $this
            ->setName('pickware:erp:stock:init')
            ->setDescription('Initialize stock entries')
            ->setHelp(<<<EOF
<info>%command.name%</info> initializes stock entries for all items without an entry.
EOF
            );
    }

    /**
     * Initialize all articles without a stock entry.
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('<info>Initializing stock entries...</info>');

        /** @var StockInitialization $stockInitialization */
        $stockInitialization = $this->getContainer()->get('pickware.erp.stock_initialization_service');
        $stockInitialization->initializeStocksOfAllUninitializedArticleDetails();

        $output->writeln('<info>Done!</info>');
    }
}
