<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

abstract class AbstractBarcodeLabelType
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var boolean
     */
    private $blocksEditable;

    /**
     * @var string[]
     */
    private $templateDirectories;

    /**
     * @param string $type
     * @param boolean $blocksEditable
     * @param string[] $templateDirectories
     */
    public function __construct(
        $type,
        $blocksEditable,
        array $templateDirectories
    ) {
        $this->type = $type;
        $this->blocksEditable = $blocksEditable;
        $this->templateDirectories = $templateDirectories;
    }

    /**
     * Creates an item provider that collects the data for all labels.
     *
     * @deprecated When removing this method, please keep in mind, that this may break the compatibility
     * with all plugins, that implement custom barcode label types (currently Pickware POS (loyalty cards)
     * and Pickware Mobile (picking box labels)).
     *
     * @param array $params
     * @param array $filter
     * @return BarcodeLabelItemProvider
     */
    abstract public function createItemProviderForFilter(array $params, array $filter);

    /**
     * Creates an item provider that collects the data for all filtered and sorted labels.
     *
     * Note: We decided to declare this method 'public' (although one would normally declare it 'abstract') to
     * not yet break the compatibility with the current releases of Pickware Mobile and Pickware POS,
     * which add custom barcode label types and hence extend this class.
     *
     * @param array $params
     * @param array $filter
     * @param array $sort
     * @return BarcodeLabelItemProvider
     */
    /* abstract */ public function createItemProvider(array $params, array $filter, array $sort)
    {
        return $this->createItemProviderForFilter($params, $filter);
    }

    /**
     * Creates an item provider that collects the data for preview labels.
     *
     * @param array $params
     * @return BarcodeLabelItemProvider
     */
    abstract public function createItemProviderForPreview(array $params);

    /**
     * Returns the variables
     *
     * @return BarcodeLabelField[]
     */
    abstract public function getFields();

    /**
     * Adds a barcode label to the print queue based on its identifier's identifier.
     *
     * @param string $identifier
     * @param int $quantity
     */
    abstract public function enqueueForPrinting($identifier, $quantity = 1);

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return bool
     */
    public function areBlocksEditable()
    {
        return $this->blocksEditable;
    }

    /**
     * @return string[]
     */
    public function getBarcodeLabelTemplateDirectories()
    {
        return $this->templateDirectories;
    }
}
