<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

interface BarcodeLabel
{
    /**
     * The id of the barcode label
     *
     * @return int
     */
    public function getId();

    /**
     * Returns the quantity in which the barcode label will be printed.
     *
     * @return int
     */
    public function getQuantity();

    /**
     * Sets the quantity in which the barcode label will be printed.
     *
     * @param int $quantity
     */
    public function setQuantity($quantity);

    /**
     * Returns the date when this barcode label was marked for printing.
     *
     * @return \DateTime
     */
    public function getAdded();
}
