<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;
use Shopware\Plugins\ViisonCommon\Classes\Document\RenderedDocument\RenderedDocument;
use Shopware\Plugins\ViisonCommon\Classes\Document\GridPaperLayout;

interface BarcodeLabelFacade
{
    /**
     * Returns the list of all available barcode label templates.
     *
     * @param string $barcodeLabelTypeIdentifier
     * @return BarcodeLabelTemplate[]
     */
    public function getLabelTemplates($barcodeLabelTypeIdentifier);

    /**
     * Returns all barcode label paper layouts.
     *
     * @return GridPaperLayout[]
     */
    public function getPaperLayouts();

    /**
     * Returns a barcode label type.
     *
     * @param string $typeIdentifier
     * @return AbstractBarcodeLabelType|null
     */
    public function getBarcodeLabelTypeByName($typeIdentifier);

    /**
     * Create the barcode label pdf.
     *
     * @param BarcodeLabelItemProvider $itemProvider
     * @param BarcodeLabelPreset $preset
     * @param int $offsetX
     * @param int $offsetY
     * @return RenderedDocument
     */
    public function renderBarcodeLabels(
        BarcodeLabelItemProvider $itemProvider,
        BarcodeLabelPreset $preset,
        $offsetX = null,
        $offsetY = null
    );

    /**
     * Update the preset's data with the given values.
     *
     * @param BarcodeLabelPreset $preset
     * @param array $values
     */
    public function updatePresetWithValues(BarcodeLabelPreset $preset, array $values);
}
