<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;

trait BarcodeLabelFacadeServiceDecoration
{
    /**
     * @var BarcodeLabelFacade
     */
    protected $decoratedService;

    /**
     * @inheritdoc
     */
    public function getLabelTemplates($barcodeLabelTypeIdentifier)
    {
        return $this->decoratedService->getLabelTemplates($barcodeLabelTypeIdentifier);
    }

    /**
     * @inheritdoc
     */
    public function getPaperLayouts()
    {
        return $this->decoratedService->getPaperLayouts();
    }

    /**
     * @inheritdoc
     */
    public function getBarcodeLabelTypeByName($typeIdentifier)
    {
        return $this->decoratedService->getBarcodeLabelTypeByName($typeIdentifier);
    }

    /**
     * @inheritdoc
     */
    public function renderBarcodeLabels(
        BarcodeLabelItemProvider $itemProvider,
        BarcodeLabelPreset $preset,
        $offsetX = null,
        $offsetY = null
    ) {
        return $this->decoratedService->renderBarcodeLabels($itemProvider, $preset, $offsetX, $offsetY);
    }

    /**
     * @inheritdoc
     */
    public function updatePresetWithValues(BarcodeLabelPreset $preset, array $values)
    {
        return $this->decoratedService->updatePresetWithValues($preset, $values);
    }
}
