<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

class BarcodeLabelField
{
    const TYPE_BARCODE = 'barcode';
    const TYPE_CONTENT = 'content';

    /**
     * @var string
     */
    public $type;

    /**
     * @var string
     */
    public $variable;

    /**
     * @var string
     */
    public $templateVariable;

    /**
     * @var string
     */
    public $description = '';

    /**
     * @param string $type
     * @param string $variable
     * @param string $templateVariable
     * @param string $description
     */
    public function __construct($type, $variable, $templateVariable, $description)
    {
        $this->type = $type;
        $this->variable = $variable;
        $this->templateVariable = $templateVariable;
        $this->description = $description;
    }

    /**
     * Converts the barcode label field to array.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'type' => $this->type,
            'variable' => $this->variable,
            'templateVariable' => $this->templateVariable,
            'description' => $this->description,
        ];
    }
}
