<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Enlight_Components_Snippet_Namespace;
use Shopware_Components_Snippet_Manager;

trait BarcodeLabelFieldTranslation
{
    /**
     * @var Enlight_Components_Snippet_Namespace
     */
    private $snippets;

    /**
     * Sets the namespace for the class.
     *
     * @param Shopware_Components_Snippet_Manager $snippetManager
     * @param string $namespace
     */
    protected function setNamespace($snippetManager, $namespace)
    {
        $this->snippets = $snippetManager->getNamespace($namespace);
    }

    /**
     * Returns the language specific value of a snippet given by its name. Optionally
     * a prefix can be specified, which will be prepended to the snippet value.
     *
     * @param string $snippetName
     * @param string $prefix
     * @return string
     */
    protected function getFieldDescription($snippetName, $prefix = '')
    {
        return ($prefix ? $prefix . ' ' : '') . $this->snippets->get($snippetName);
    }
}
