<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

trait BarcodeLabelGrouping
{
    /**
     * Condenses the barcode label array to one label object per identifier. The returned array
     * is sorted by the identifiers as well.
     *
     * @param GroupableBarcodeLabel[] $barcodeLabels
     * @return GroupableBarcodeLabel[]
     */
    public function groupBarcodeLabelsByIdentifier(array $barcodeLabels)
    {
        $labels = [];
        foreach ($barcodeLabels as $barcodeLabel) {
            $labelIdentifier = $barcodeLabel->getIdentifier();

            if (isset($labels[$labelIdentifier]) && $labels[$labelIdentifier] instanceof GroupableBarcodeLabel) {
                $labels[$labelIdentifier]->addQuantity($barcodeLabel->getQuantity());
            } else {
                $labels[$labelIdentifier] = $barcodeLabel;
            }
        }

        return $labels;
    }
}
