<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

interface BarcodeLabelItemProvider
{
    /**
     * Returns all shop-specific information which is accessible inside barcode label templates.
     *
     * @return array
     */
    public function getContext();

    /**
     * Returns all specific information needed in the barcode label templates for a given list of barcode labels.
     *
     * If a single label will be printed multiple times, the returned array contains all detail information for that
     * label exactly as many times as it will be printed.
     *
     * @return array
     */
    public function getItems();

    /**
     * Returns the current barcode label type.
     *
     * @return AbstractBarcodeLabelType
     */
    public function getType();
}
