<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\Components\Model\ModelManager;
use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;
use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPresetBlock;

class BarcodeLabelPresetsService implements BarcodeLabelPresets
{
    /**
     * @var ModelManager
     */
    private $entityManager;

    /**
     * @var BarcodeLabelTemplates
     */
    private $barcodeLabelTemplates;

    /**
     * @param ModelManager $entityManager
     * @param BarcodeLabelTemplates $barcodeLabelTemplates
     */
    public function __construct($entityManager, BarcodeLabelTemplates $barcodeLabelTemplates)
    {
        $this->entityManager = $entityManager;
        $this->barcodeLabelTemplates = $barcodeLabelTemplates;
    }

    /**
     * @inheritdoc
     */
    public function updatePresetBlocksWithValues(AbstractBarcodeLabelType $type, BarcodeLabelPreset $preset, array $values)
    {
        foreach ($preset->getBlocks() as $presetBlock) {
            $this->entityManager->remove($presetBlock);
            $this->entityManager->flush($presetBlock);
        }

        $templateIdentifier = $values['templateIdentifier'];
        $labelTemplate = $this->barcodeLabelTemplates->getTemplate($type, $templateIdentifier);

        $preset->getBlocks()->clear();
        foreach ($labelTemplate->blocks as $templateBlock) {
            if (isset($values['block-' . $templateBlock->name])) {
                $presetBlock = new BarcodeLabelPresetBlock($preset);
                $presetBlock->setName($templateBlock->name);
                $presetBlock->setValue($values['block-' . $templateBlock->name]);
            }
        }
    }
}
