<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;

trait BarcodeLabelPresetsServiceDecoration
{
    /**
     * @var BarcodeLabelPresets
     */
    protected $decoratedService;

    /**
     * @inheritdoc
     */
    public function updatePresetBlocksWithValues(AbstractBarcodeLabelType $type, BarcodeLabelPreset $preset, array $values)
    {
        return $this->decoratedService->updatePresetBlocksWithValues($type, $preset, $values);
    }
}
