<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;
use Shopware\Plugins\ViisonCommon\Classes\Document\RenderedDocument\RenderedDocument;

interface BarcodeLabelRenderer
{
    /**
     * Renders a PDF for the given barcode labels using the correct template and text fields.
     *
     * @param BarcodeLabelItemProvider $itemProvider
     * @param BarcodeLabelPreset $preset
     * @param int $offsetX
     * @param int $offsetY
     * @return RenderedDocument
     */
    public function render(
        BarcodeLabelItemProvider $itemProvider,
        BarcodeLabelPreset $preset,
        $offsetX = null,
        $offsetY = null
    );
}
