<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BarcodeLabelPreset;

trait BarcodeLabelRendererServiceDecoration
{
    /**
     * @var BarcodeLabelRenderer
     */
    protected $decoratedService;

    /**
     * @inheritdoc
     */
    public function render(
        BarcodeLabelItemProvider $itemProvider,
        BarcodeLabelPreset $preset,
        $offsetX = null,
        $offsetY = null
    ) {
        return $this->decoratedService->render($itemProvider, $preset, $offsetX, $offsetY);
    }
}
