<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use InvalidArgumentException;

interface BarcodeLabelTemplates
{
    /**
     * Returns a barcode label template given by its unique identifier.
     *
     * @param AbstractBarcodeLabelType $type
     * @param string $identifier
     * @return BarcodeLabelTemplate
     * @throws InvalidArgumentException if the template identifier is not valid
     */
    public function getTemplate(AbstractBarcodeLabelType $type, $identifier);

    /**
     * Returns the list of all available barcode label templates.
     *
     * @param AbstractBarcodeLabelType $type
     * @return BarcodeLabelTemplate[]
     */
    public function getTemplates(AbstractBarcodeLabelType $type);
}
