<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

trait BarcodeLabelTemplatesServiceDecoration
{
    /**
     * @var BarcodeLabelTemplates
     */
    protected $decoratedService;

    /**
     * @inheritdoc
     */
    public function getTemplate(AbstractBarcodeLabelType $type, $identifier)
    {
        return $this->decoratedService->getTemplate($type, $identifier);
    }

    /**
     * @inheritdoc
     */
    public function getTemplates(AbstractBarcodeLabelType $type)
    {
        return $this->decoratedService->getTemplates($type);
    }
}
