<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

use Zend\Barcode\Barcode;

interface BarcodeRenderer
{
    /**
     * Creates a barcode image for an ean barcode with the correct ean type.
     *
     * @param string $value
     * @param bool $drawText
     * @return string|null
     */
    public function createEanBarcode($value, $drawText = true);

    /**
     * Returns the type of the barcode that will be used for the given $ean.
     *
     * @param string $ean
     * @return null|string One of the constants self::BARCODE_TYPE_* or null if no matching barcode was found.
     */
    public function getBarcodeTypeByEanLength($ean);

    /**
     * Creates a code 128 barcode.
     *
     * @param string $value
     * @return string
     */
    public function createCode128Barcode($value);
}
