<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

trait BarcodeRendererServiceDecoration
{
    /**
     * @var BarcodeRenderer
     */
    protected $decoratedService;

    /**
     * @inheritdoc
     */
    public function createEanBarcode($value, $drawText = true)
    {
        return $this->decoratedService->createEanBarcode($value, $drawText);
    }

    /**
     * @inheritdoc
     */
    public function getBarcodeTypeByEanLength($ean)
    {
        return $this->decoratedService->getBarcodeTypeByEanLength($ean);
    }

    /**
     * @inheritdoc
     */
    public function createCode128Barcode($value)
    {
        return $this->decoratedService->createCode128Barcode($value);
    }
}
