<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BinLocation;

use Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel\BinLocationBarcodeLabel;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\AbstractBarcodeLabelType;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelItemProvider;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeRenderer;

class BinLocationItemProvider implements BarcodeLabelItemProvider
{
    /**
     * @var BarcodeRenderer
     */
    private $barcodeRenderer;

    /**
     * @var AbstractBarcodeLabelType
     */
    private $type;

    /**
     * @var BinLocationBarcodeLabel
     */
    private $labels;

    /**
     * @param BarcodeRenderer $barcodeRenderer
     * @param AbstractBarcodeLabelType $type
     * @param BinLocationBarcodeLabel[] $labels
     */
    public function __construct(
        BarcodeRenderer $barcodeRenderer,
        AbstractBarcodeLabelType $type,
        array $labels
    ) {
        $this->barcodeRenderer = $barcodeRenderer;
        $this->type = $type;
        $this->labels = $labels;
    }

    /**
     * @inheritdoc
     */
    public function getContext()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getItems()
    {
        $barcodeLabelsData = [];
        foreach ($this->labels as $barcodeLabel) {
            $binLocation = $barcodeLabel->getBinLocation();
            $barcodeLabelData = [
                'binLocationCode' => $binLocation->getCode(),
                'warehouseCode' => $binLocation->getWarehouse()->getCode(),
                'warehouseName' => $binLocation->getWarehouse()->getName(),
                'barcode' => $this->barcodeRenderer->createCode128Barcode(
                    '^3' . $binLocation->getWarehouse()->getCode() . '$' . $binLocation->getCode()
                ),
            ];
            for ($i = 0; $i < $barcodeLabel->getQuantity(); $i++) {
                $barcodeLabelsData[] = $barcodeLabelData;
            }
        }

        return $barcodeLabelsData;
    }

    /**
     * @inheritdoc
     */
    public function getType()
    {
        return $this->type;
    }
}
