<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel;

interface GroupableBarcodeLabel
{
    /**
     * Get the current quantity of the label.
     *
     * @return int
     */
    public function getQuantity();

    /**
     * Set the quantity of the label.
     *
     * @param int $quantity
     */
    public function setQuantity($quantity);

    /**
     * Returns a unique identifier by which the labels should be grouped.
     *
     * @return string
     */
    public function getIdentifier();
}
