<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Cancellation;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipmentItem;
use Shopware\Models\Order\Detail as OrderDetail;
use Shopware\Models\Order\Order;

trait OrderCancelerServiceDecoration
{
    /**
     * @var OrderCanceler
     */
    protected $decoratedService;

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::cancelShippingCostsOfOrder
     * @param Order $order
     */
    public function cancelShippingCostsOfOrder(Order $order)
    {
        $this->decoratedService->cancelShippingCostsOfOrder($order);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::cancelRemainingQuantityToShipOfOrderDetail
     * @param OrderDetail $orderDetail
     * @param $quantity
     */
    public function cancelRemainingQuantityToShipOfOrderDetail(OrderDetail $orderDetail, $quantity)
    {
        $this->decoratedService->cancelRemainingQuantityToShipOfOrderDetail($orderDetail, $quantity);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::cancelReturnedQuantityOfReturnShipmentItem
     * @param ReturnShipmentItem $returnShipmentItem
     * @param $quantity
     */
    public function cancelReturnedQuantityOfReturnShipmentItem(ReturnShipmentItem $returnShipmentItem, $quantity)
    {
        $this->decoratedService->cancelReturnedQuantityOfReturnShipmentItem($returnShipmentItem, $quantity);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::getMaxCancelUnshipped
     * @param OrderDetail $orderDetail
     * @return int
     */
    public function getMaxCancelUnshipped(OrderDetail $orderDetail)
    {
        return $this->decoratedService->getMaxCancelUnshipped($orderDetail);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::getMaxCancelReturned
     * @param ReturnShipmentItem $returnShipmentItem
     * @return int
     */
    public function getMaxCancelReturned(ReturnShipmentItem $returnShipmentItem)
    {
        return $this->decoratedService->getMaxCancelReturned($returnShipmentItem);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::isCancelUnshippedAllowed
     * @param OrderDetail $orderDetail
     * @param $quantity
     * @return bool
     */
    public function isCancelUnshippedAllowed(OrderDetail $orderDetail, $quantity)
    {
        return $this->decoratedService->isCancelUnshippedAllowed($orderDetail, $quantity);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::isCancelReturnedAllowed
     * @param ReturnShipmentItem $returnShipmentItem
     * @param $quantity
     * @return bool
     */
    public function isCancelReturnedAllowed(ReturnShipmentItem $returnShipmentItem, $quantity)
    {
        return $this->decoratedService->isCancelReturnedAllowed($returnShipmentItem, $quantity);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::assertCancelUnshippedAllowed
     * @param OrderDetail $orderDetail
     * @param $quantity
     */
    public function assertCancelUnshippedAllowed(OrderDetail $orderDetail, $quantity)
    {
        $this->decoratedService->assertCancelUnshippedAllowed($orderDetail, $quantity);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCanceler::assertCancelReturnedAllowed
     * @param ReturnShipmentItem $returnShipmentItem
     * @param $quantity
     */
    public function assertCancelReturnedAllowed(ReturnShipmentItem $returnShipmentItem, $quantity)
    {
        $this->decoratedService->assertCancelReturnedAllowed($returnShipmentItem, $quantity);
    }
}
