<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\DerivedPropertyUpdater;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

trait DerivedPropertyUpdaterServiceDecoration
{
    /**
     * @var DerivedPropertyUpdater
     */
    protected $decoratedService;

    /**
     * @see DerivedPropertyUpdater::recalculateAllArticleDetailMinimumOnlineStocks()
     */
    public function recalculateAllArticleDetailMinimumOnlineStocks()
    {
        $this->decoratedService->recalculateAllArticleDetailMinimumOnlineStocks();
    }

    /**
     * @see DerivedPropertyUpdater::recalculateMinimumOnlineStockForArticleDetail()
     *
     * @param ArticleDetail $articleDetail
     */
    public function recalculateMinimumOnlineStockForArticleDetail(ArticleDetail $articleDetail)
    {
        $this->decoratedService->recalculateMinimumOnlineStockForArticleDetail($articleDetail);
    }

    /**
     * @see DerivedPropertyUpdater::recalculateTotalPhysicalStockForSaleForArticleDetail()
     *
     * @param ArticleDetail $articleDetail
     */
    public function recalculateTotalPhysicalStockForSaleForArticleDetail(ArticleDetail $articleDetail)
    {
        $this->decoratedService->recalculateTotalPhysicalStockForSaleForArticleDetail($articleDetail);
    }

    /**
     * @see DerivedPropertyUpdater::recalculatePhysicalStockForSaleForArticleDetailInWarehouse()
     *
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     */
    public function recalculatePhysicalStockForSaleForArticleDetailInWarehouse(
        ArticleDetail $articleDetail,
        Warehouse $warehouse
    ) {
        $this->decoratedService->recalculatePhysicalStockForSaleForArticleDetailInWarehouse($articleDetail, $warehouse);
    }

    /**
     * @see DerivedPropertyUpdater::recalculateReservedStockForArticleDetailInWarehouse()
     *
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     */
    public function recalculateReservedStockForArticleDetailInWarehouse(
        ArticleDetail $articleDetail,
        Warehouse $warehouse
    ) {
        $this->decoratedService->recalculateReservedStockForArticleDetailInWarehouse($articleDetail, $warehouse);
    }

    /**
     * @see DerivedPropertyUpdater::recalculateIncomingStockForArticleDetail()
     *
     * @param ArticleDetail $articleDetail
     */
    public function recalculateIncomingStockForArticleDetail(ArticleDetail $articleDetail)
    {
        $this->decoratedService->recalculateIncomingStockForArticleDetail($articleDetail);
    }
}
