<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Enlight_Components_Mail;
use Shopware\Models\Order\Document\Document;
use Shopware\Models\Shop\Shop;

interface DocumentMailing
{
    /**
     * Creates (but does not send) a new mail object based on the template having the given `$templateName` and attaches
     * the file of the passed `$document` to it. Finally the mail is returned.
     *
     * @param string $templateName
     * @param array $templateContext
     * @param Document $document
     * @param Shop|null $shop
     * @param array $mailConfig
     * @return Enlight_Components_Mail
     */
    public function createDocumentMailFromTemplate($templateName, array $templateContext, Document $document, Shop $shop = null, array $mailConfig = []);
}
