<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class DocumentMailingException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @inheritdoc
     */
    public function __construct($message, $code = 0, Exception $previousException = null)
    {
        parent::__construct($message, $code, $previousException);
        $this->setSnippetNamespace('viison_pickware_erp/components/document/document_mailing_exception');
    }

    /**
     * @param string $templateName
     * @return self
     */
    public static function mailTemplateNotFound($templateName)
    {
        $messageArguments = [$templateName];
        $exception = new self(vsprintf('Email template "%1$s" does not exist.', $messageArguments));
        $exception->setSnippetName('mail_template_not_found');
        $exception->setSnippetArguments($messageArguments);

        return $exception;
    }

    /**
     * @param string $filePath
     * @param Exception|null $previousException
     * @return self
     */
    public static function documentFileNotReadable($filePath, Exception $previousException = null)
    {
        $messageArguments = [$filePath];
        $exception = new self(vsprintf(
            'Document at path "%1$s" is not readable or does not exist.',
            $messageArguments
        ), 0, $previousException);
        $exception->setSnippetName('document_file_not_readable');
        $exception->setSnippetArguments($messageArguments);

        return $exception;
    }
}
