<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Enlight_Components_Mail;
use Shopware\Models\Order\Document\Document;
use Shopware\Models\Shop\Shop;

trait DocumentMailingServiceDecoration
{
    /**
     * @var DocumentMailingService
     */
    protected $decoratedService;

    /**
     * @see DocumentMailing::createDocumentMailFromTemplate()
     *
     * @param string $templateName
     * @param array $templateContext
     * @param Document $document
     * @param Shop|null $shop
     * @param array $mailConfig
     * @return Enlight_Components_Mail
     */
    public function createDocumentMailFromTemplate(
        $templateName,
        array $templateContext,
        Document $document,
        Shop $shop = null,
        array $mailConfig = []
    ) {
        return $this->decoratedService->createDocumentMailFromTemplate(
            $templateName,
            $templateContext,
            $document,
            $shop,
            $mailConfig
        );
    }
}
