<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Shopware\Models\Order\Document\Document;

interface InvoiceArchive
{
    /**
     * Sends the file of the given `$document` to all email addresses, which are configured to be recipients of archived
     * invoice documents.
     *
     * @param Document $document
     */
    public function sendDocumentToInvoiceArchive(Document $document);
}
