<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Enlight_Components_Mail;
use Shopware\Models\Order\Document\Document;
use Shopware\Models\Shop\Shop;

trait InvoiceArchiveServiceDecoration
{
    /**
     * @var InvoiceArchive
     */
    protected $decoratedService;

    /**
     * @see InvoiceArchive::sendDocumentToInvoiceArchive()
     *
     * @param Document $document
     */
    public function sendDocumentToInvoiceArchive(Document $document)
    {
        $this->decoratedService->sendDocumentToInvoiceArchive($document);
    }
}
