<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Shopware\Models\Document\Document as DocumentType;
use Shopware\Models\Order\Document\Document;
use Shopware\Models\Order\Order;

trait OrderDocumentCreationServiceDecoration
{
    /**
     * @var OrderDocumentCreation
     */
    protected $decoratedService;

    /**
     * @see OrderDocumentCreation::createOrderCancellationDocument()
     *
     * @param Order $order
     * @param DocumentType $documentType
     * @param array $positions
     * @param string $invoiceNumber
     * @param string $comment
     * @param string $dateString
     * @param boolean $cancelShippingCost
     * @return Document
     */
    public function createOrderCancellationDocument(
        Order $order,
        DocumentType $documentType,
        array $positions,
        $invoiceNumber,
        $comment,
        $dateString,
        $cancelShippingCost
    ) {
        return $this->decoratedService->createOrderCancellationDocument(
            $order,
            $documentType,
            $positions,
            $invoiceNumber,
            $comment,
            $dateString,
            $cancelShippingCost
        );
    }

    /**
     * @see OrderDocumentCreation::createOrderDocument()
     *
     * @param Order $order
     * @param DocumentType $documentType
     * @param array $documentConfig
     * @return Document
     */
    public function createOrderDocument(Order $order, DocumentType $documentType, array $documentConfig = [])
    {
        return $this->decoratedService->createOrderDocument($order, $documentType, $documentConfig);
    }

    /**
     * @see OrderDocumentCreation::showOrderCancellationDocumentPreview()
     *
     * @param Order $order
     * @param DocumentType $documentType
     * @param array $positions
     * @param string $invoiceNumber
     * @param string $comment
     * @param string|null $dateString A formatted date string for the invoice. If null, today's date is used.
     * @param boolean $cancelShippingCost
     */
    public function showOrderCancellationDocumentPreview(
        Order $order,
        DocumentType $documentType,
        array $positions,
        $invoiceNumber,
        $comment,
        $dateString,
        $cancelShippingCost
    ) {
        return $this->decoratedService->showOrderCancellationDocumentPreview(
            $order,
            $documentType,
            $positions,
            $invoiceNumber,
            $comment,
            $dateString,
            $cancelShippingCost
        );
    }
}
