<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;

interface PickListDocumentCreation
{
    /**
     * Replaces the positions in the passed `$templateVariables` with instructions for picking the relevant order items
     * and adds all other variables that are required by a pick list document (e.g. warehouse and bin locations) to the
     * template variables, which are finally returned.
     *
     * @param array $templateVariables
     * @param Warehouse $warehouse
     * @return array
     * @throws PickListDocumentException Iff the resulting pick list would be empty.
     */
    public function createPickListDocumentTemplateVariables(array $templateVariables, Warehouse $warehouse);

    /**
     * Replaces the template variables with preview data for a demo pick list document for the given $document. Use this
     * method when handling a pick list preview document which naturally lacks the relevant demo data.
     *
     * @param \Shopware_Components_Document $document
     * @return array
     */
    public function createPickListDocumentTemplatePreviewVariables(\Shopware_Components_Document $document);
}
