<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;

trait PickListDocumentCreationServiceDecoration
{
    /**
     * @var PickListDocumentCreation
     */
    protected $decoratedService;

    /**
     * @see PickListDocumentCreation::createPickListDocumentTemplateVariables()
     *
     * @param array $templateVariables
     * @param Warehouse $warehouse
     * @return array
     * @throws PickListDocumentException
     */
    public function createPickListDocumentTemplateVariables(array $templateVariables, Warehouse $warehouse)
    {
        return $this->decoratedService->createPickListDocumentTemplateVariables($templateVariables, $warehouse);
    }

    /**
     * @see PickListDocumentCreation::createPickListDocumentTemplatePreviewVariables()
     *
     * @param \Shopware_Components_Document $document
     * @return array
     */
    public function createPickListDocumentTemplatePreviewVariables(\Shopware_Components_Document $document)
    {
        return $this->decoratedService->createPickListDocumentTemplatePreviewVariables($document);
    }
}
