<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Document;

use Exception;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class PickListDocumentException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @inheritdoc
     */
    public function __construct($message, $code = 0, Exception $previousException = null)
    {
        parent::__construct($message, $code, $previousException);
        $this->setSnippetNamespace('viison_pickware_erp/components/document/pick_list_document_exception');
    }

    /**
     * @param string $orderNumber
     * @param Warehouse $warehouse
     * @return self
     */
    public static function noPickableItemsInOrder($orderNumber, Warehouse $warehouse)
    {
        $messageArguments = [
            $orderNumber,
            $warehouse->getDisplayName(),
        ];
        $exception = new self(vsprintf(
            'Order with number "%1$s" does not contain any pickable order details in warehouse "%2$s".',
            $messageArguments
        ));
        $exception->setSnippetName('no_pickable_items_in_order');
        $exception->setSnippetArguments($messageArguments);

        return $exception;
    }
}
