<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityCalculator;

use Shopware\Models\Order\Detail as OrderDetail;

trait OrderDetailQuantityCalculatorDecoration
{
    /**
     * @var OrderDetailQuantityCalculator
     */
    private $decoratedService;

    /**
     * @inheritdoc
     */
    public function calculateOrderedQuantity(OrderDetail $orderDetail)
    {
        return $this->decoratedService->calculateOrderedQuantity($orderDetail);
    }

    /**
     * @inheritdoc
     */
    public function calculateRemainingQuantityToShip($orderDetail)
    {
        return $this->decoratedService->calculateCancelledRemainingQuantityToShip($orderDetail);
    }

    /**
     * @inheritdoc
     */
    public function calculateReturnedQuantity(OrderDetail $orderDetail)
    {
        return $this->decoratedService->calculateReturnedQuantity($orderDetail);
    }

    /**
     * @inheritdoc
     */
    public function calculateCancelledQuantityOfReturnShipmentItems(OrderDetail $orderDetail)
    {
        return $this->decoratedService->calculateCancelledQuantityOfReturnShipmentItems($orderDetail);
    }

    /**
     * @inheritdoc
     */
    public function calculateCancelledRemainingQuantityToShip(OrderDetail $orderDetail)
    {
        return $this->decoratedService->calculateCancelledRemainingQuantityToShip($orderDetail);
    }

    /**
     * @inheritdoc
     */
    public function calculateShippedAndNotReturnedQuantity(OrderDetail $orderDetail)
    {
        return $this->decoratedService->calculateShippedAndNotReturnedQuantity($orderDetail);
    }
}
