<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityValidator;

use Shopware\Models\Order\Detail as OrderDetail;

interface OrderDetailQuantityValidator
{
    /**
     * Returns whether the provided combinations of $quantity and $shippedQuantity is allowed for the $orderDetail
     *
     * Parameter $orderDetail does not have a type-hint because the proxy generation is SW 5.2 is broken. It would
     * generate a proxy classes without type-hints what leads to methods being incompatible with their parents. Since
     * we need to hook this method in ShopwarePickwareMobile the type-hint is dropped.
     *
     * @param OrderDetail $orderDetail
     * @param int $quantity
     * @param int $shippedQuantity
     * @return bool
     */
    public function isQuantityAndShippedQuantityCombinationValid($orderDetail, $quantity, $shippedQuantity);

    /**
     * @param OrderDetail $orderDetail
     * @param int $quantity
     * @param int $shippedQuantity
     * @throws OrderDetailQuantityViolationException
     */
    public function validateQuantityAndShippedQuantityCombination(OrderDetail $orderDetail, $quantity, $shippedQuantity);

    /**
     * @param int $quantity
     * @param int $shippedQuantity
     * @return bool
     */
    public function isQuantityAndShippedQuantityCombinationValidForOrderDetailCreation($quantity, $shippedQuantity);

    /**
     * @param int $quantity
     * @param int $shippedQuantity
     * @throws OrderDetailQuantityViolationException
     */
    public function validateQuantityAndShippedQuantityCombinationForOrderDetailCreation($quantity, $shippedQuantity);
}
