<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityValidator;

use Shopware\Models\Order\Detail as OrderDetail;

trait OrderDetailQuantityValidatorServiceDecoration
{
    /**
     * @var OrderDetailQuantityValidator
     */
    protected $decoratedService;

    /**
     * @param OrderDetail $orderDetail
     * @param $quantity
     * @param $shipped
     * @return bool
     */
    public function isQuantityAndShippedQuantityCombinationValid($orderDetail, $quantity, $shipped)
    {
        return $this->decoratedService->isQuantityAndShippedQuantityCombinationValid($orderDetail, $quantity, $shipped);
    }

    /**
     * @param OrderDetail $orderDetail
     * @param $quantity
     * @param $shipped
     * @return mixed
     */
    public function validateQuantityAndShippedQuantityCombination(OrderDetail $orderDetail, $quantity, $shipped)
    {
        return $this->decoratedService->validateQuantityAndShippedQuantityCombination($orderDetail, $quantity, $shipped);
    }

    /**
     * @param $quantity
     * @param $shipped
     * @return mixed
     */
    public function validateQuantityAndShippedQuantityCombinationForOrderDetailCreation($quantity, $shipped)
    {
        return $this->decoratedService->validateQuantityAndShippedQuantityCombinationForOrderDetailCreation($quantity, $shipped);
    }

    /**
     * @param $quantity
     * @param $shipped
     * @return bool
     */
    public function isQuantityAndShippedQuantityCombinationValidForOrderDetailCreation($quantity, $shipped)
    {
        return $this->decoratedService->isQuantityAndShippedQuantityCombinationValidForOrderDetailCreation($quantity, $shipped);
    }
}
