<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\PluginConfig;

use Shopware\Models\Document\Document as DocumentType;
use Shopware\Models\Media\Album;

interface PluginConfig
{
    /**
     * Returns the pick list DocumentType by matching its key/name.
     *
     * @return DocumentType|null
     */
    public function getPickListDocumentType();

    /**
     * Returns the supplier order DocumentType by matching its key/name.
     *
     * @return DocumentType|null
     */
    public function getSupplierOrderDocumentTye();

    /**
     * Returns the trimmed and filtered email addresses configured as recipients for archived invoices.
     *
     * @return string[]
     */
    public function getInvoiceArchiveEmailAddresses();

    /**
     * @return bool Whether the "About Pickware ERP" backend window should be displayed
     */
    public function getDisplayAboutPickwareErpWindow();

    /**
     * @param bool $newValue Whether or not the "About Pickware ERP" backend window should be displayed
     */
    public function setDisplayAboutPickwareErpWindow($newValue);

    /**
     * Returns the last printed article preset ids.
     *
     * @return int[]
     */
    public function getLastPrintedPresetIds();

    /**
     * Sets the last printed preset id for a preset type.
     *
     * @param string $typeIdentifier
     * @param int $presetId
     */
    public function setLastPrintedPresetId($typeIdentifier, $presetId);

    /**
     * Deletes all last printed preset ids.
     */
    public function clearLastPrintedPresetIds();

    /**
     * Returns all folders that contain barcode label templates.
     *
     * @return string[]
     */
    public function getBarcodeLabelTemplateDirectories();

    /**
     * Returns the default barcode label template directory.
     *
     * @return string
     */
    public function getDefaultBarcodeLabelTemplateDirectory();

    /**
     * Returns the barcode label directory for custom templates.
     *
     * @return string
     */
    public function getCustomBarcodeLabelTemplateDirectory();

    /**
     * Returns the path to the fallback image for templates without preview images.
     *
     * @return string
     */
    public function getPreviewFallbackImagePath();

    /**
     * @return Album|null
     */
    public function getReturnShipmentMediaAlbum();

    /**
     * @return bool
     */
    public function getShowCurrentStockWhenStocktaking();
}
