<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\PluginConfig;

use Shopware\Models\Document\Document as DocumentType;
use Shopware\Models\Media\Album;

trait PluginConfigServiceDecoration
{
    /**
     * @var PluginConfig
     */
    protected $decoratedService;

    /**
     * @see PluginConfig::getPickListDocumentType()
     *
     * @return DocumentType|null
     */
    public function getPickListDocumentType()
    {
        return $this->decoratedService->getPickListDocumentType();
    }

    /**
     * @see PluginConfig::getSupplierOrderDocumentTye()
     *
     * @return DocumentType|null
     */
    public function getSupplierOrderDocumentTye()
    {
        return $this->decoratedService->getSupplierOrderDocumentTye();
    }

    /**
     * @see PluginConfig::getInvoiceArchiveEmailAddresses()
     *
     * @return string[]
     */
    public function getInvoiceArchiveEmailAddresses()
    {
        return $this->decoratedService->getInvoiceArchiveEmailAddresses();
    }

    /**
     * @see PluginConfig::getDisplayAboutPickwareErpWindow()
     *
     * @return bool
     */
    public function getDisplayAboutPickwareErpWindow()
    {
        return $this->decoratedService->getDisplayAboutPickwareErpWindow();
    }

    /**
     * @see PluginConfig::setDisplayAboutPickwareErpWindow()
     *
     * @param bool $newValue
     */
    public function setDisplayAboutPickwareErpWindow($newValue)
    {
        return $this->decoratedService->setDisplayAboutPickwareErpWindow($newValue);
    }

    /**
     * @see PluginConfig::getLastPrintedPresetIds()
     *
     * @return int[]
     */
    public function getLastPrintedPresetIds()
    {
        return $this->decoratedService->getLastPrintedPresetIds();
    }

    /**
     * @see PluginConfig::setLastPrintedPresetId()
     *
     * @param string $typeIdentifier
     * @param int $presetId
     */
    public function setLastPrintedPresetId($typeIdentifier, $presetId)
    {
        $this->decoratedService->setLastPrintedPresetId($typeIdentifier, $presetId);
    }

    /**
     * @see PluginConfig::clearLastPrintedPresetIds()
     * Deletes all last printed preset ids.
     */
    public function clearLastPrintedPresetIds()
    {
        $this->decoratedService->clearLastPrintedPresetIds();
    }

    /**
     * @see PluginConfig::getBarcodeLabelTemplateDirectories()
     *
     * @return string[]
     */
    public function getBarcodeLabelTemplateDirectories()
    {
        return $this->decoratedService->getBarcodeLabelTemplateDirectories();
    }

    /**
     * @see PluginConfig::getDefaultBarcodeLabelTemplateDirectory()
     *
     * @return string
     */
    public function getDefaultBarcodeLabelTemplateDirectory()
    {
        return $this->decoratedService->getDefaultBarcodeLabelTemplateDirectory();
    }

    /**
     * @see PluginConfig::getCustomBarcodeLabelTemplateDirectory()
     *
     * @return string
     */
    public function getCustomBarcodeLabelTemplateDirectory()
    {
        return $this->decoratedService->getCustomBarcodeLabelTemplateDirectory();
    }

    /**
     * @see PluginConfig::getPreviewFallbackImagePath()
     *
     * @return string
     */
    public function getPreviewFallbackImagePath()
    {
        return $this->decoratedService->getPreviewFallbackImagePath();
    }

    /**
     * @see PluginConfig::getReturnShipmentMediaAlbum()
     *
     * @return Album|null
     */
    public function getReturnShipmentMediaAlbum()
    {
        return $this->decoratedService->getReturnShipmentMediaAlbum();
    }

    /**
     * @see PluginConfig::getShowCurrentStockWhenStocktaking()
     *
     * @return bool
     */
    public function getShowCurrentStockWhenStocktaking()
    {
        return $this->decoratedService->getShowCurrentStockWhenStocktaking();
    }
}
