<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Idempotency;

use Shopware\CustomModels\ViisonPickwareERP\RestApi\RestApiIdempotentOperation;

interface AtomicPhaseResult
{
    /**
     * Called after successfully executing the atomic phase, which returned this instance.
     *
     * @param RestApiIdempotentOperation $idempotentOperation
     */
    public function finalize(RestApiIdempotentOperation $idempotentOperation);
}
