<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Idempotency;

use Exception;
use Shopware\CustomModels\ViisonPickwareERP\RestApi\RestApiIdempotentOperation;

class IdempotencyException extends Exception
{
    /**
     * @return self
     */
    public static function invalidOrMissingIdempotencyKeyHeader()
    {
        return new self(
            'Cannot create idempotent operation, because the request has an invalid or missing idempotency key header.'
        );
    }

    /**
     * @param RestApiIdempotentOperation $idempotentOperation
     * @param string $recoveryPoint
     * @return self
     */
    public static function invalidRecoveryPoint(RestApiIdempotentOperation $idempotentOperation, $recoveryPoint)
    {
        return new self(sprintf(
            'No atomic execution phase found for current recovery point "%s" of idempotency key "%s".',
            $recoveryPoint,
            $idempotentOperation->getIdempotencyKey()
        ));
    }

    /**
     * @return self
     */
    public static function invalidRetryRequest()
    {
        return new self('The body of requests that are sent multiple times with the same idempotency key must have identical contents.');
    }
}
