<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Idempotency;

use Shopware\CustomModels\ViisonPickwareERP\RestApi\RestApiIdempotentOperation;

class RecoveryPointResult implements AtomicPhaseResult
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     */
    private $intermediateState;

    /**
     * @param string $name
     * @param string|null $intermediateState
     */
    public function __construct($name, $intermediateState = null)
    {
        $this->name = $name;
        $this->intermediateState = $intermediateState;
    }

    /**
     * @inheritdoc
     */
    public function finalize(RestApiIdempotentOperation $idempotentOperation)
    {
        $idempotentOperation->setRecoveryPoint($this->name);
        $idempotentOperation->setIntermediateState($this->intermediateState);
    }
}
