<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Idempotency;

use DateTime;
use Shopware\CustomModels\ViisonPickwareERP\RestApi\RestApiIdempotentOperation;

class ResponseResult implements AtomicPhaseResult
{
    /**
     * @var int
     */
    protected $status;

    /**
     * @var array
     */
    protected $data;

    /**
     * @param int $status
     * @param array $data
     */
    public function __construct($status, array $data)
    {
        $this->status = $status;
        $this->data = $data;
    }

    /**
     * @inheritdoc
     */
    public function finalize(RestApiIdempotentOperation $idempotentOperation)
    {
        $idempotentOperation->setRecoveryPoint(RestApiIdempotentOperation::RECOVERY_POINT_FINISHED);
        $idempotentOperation->setResponseCode($this->status);

        $responseData = $this->data;
        // Convert all DateTime instances contained in the response data to ISO-8601 strings to make them usable in JSON
        // responses (see `Shopware_Controllers_Api_Rest::postDispatch()`).
        array_walk_recursive($responseData, function (&$value) {
            if ($value instanceof DateTime) {
                $value = $value->format(DateTime::ISO8601);
            }
        });
        $idempotentOperation->setResponseData($responseData);
    }
}
