<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\RequestLogging;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;

abstract class AbstractRestApiRequestLogFilterSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            RestApiRequestLoggerService::EVENT_FILTER_SHOULD_LOG_REQUEST => 'onFilterShouldLogRequest',
            RestApiRequestLoggerService::EVENT_FILTER_LOGGED_RESPONSE_JSON => 'onFilterLoggedResponseJson',
        ];
    }

    /**
     * Filters specific fields from the given $responseJson and returns the filtered data.
     *
     * @param array $responseJson
     * @param \Enlight_Controller_Request_Request $request
     * @return array
     */
    abstract public function filterLoggedResponseJson(array $responseJson, \Enlight_Controller_Request_Request $request);

    /**
     * Filters whether the passe `$request` should be logged.
     *
     * Note: By default no requests are logged! Hence you must override this method to whitelist any requests that
     * should be logged.
     *
     * @param \Enlight_Controller_Request_RequestHttp $request
     * @return boolean
     */
    public function shouldLogRequest(\Enlight_Controller_Request_RequestHttp $request)
    {
        // Don't log any requests by default
        return false;
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     * @return boolean
     */
    public function onFilterShouldLogRequest(\Enlight_Event_EventArgs $args)
    {
        return $args->getReturn() || $this->shouldLogRequest($args->get('request'));
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     * @return array|null
     */
    public function onFilterLoggedResponseJson(\Enlight_Event_EventArgs $args)
    {
        $responseJson = $args->getReturn();
        $request = $args->get('request');
        $filteredResponseJson = $this->filterLoggedResponseJson($responseJson, $request);

        return $filteredResponseJson;
    }
}
