<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi;

use Shopware\Models\Article\Detail as ArticleDetail;

interface RestApiArticleDetailUpdater
{
    /**
     * Removes several custom Pickware article detail attribute fields from the passed `$postData`, if present, and
     * returns the cleaned data.
     *
     * @param array $postData
     * @return array
     */
    public function removeCustomAttributesFromPostData(array $postData);

    /**
     * Removes the fields 'inStock' and 'stockMin' from the passed `$postData`, if present, and returns the
     * cleaned data.
     *
     * @param array $postData
     * @return array
     */
    public function removeStockFieldsFromPostData(array $postData);

    /**
     * Checks the passed `$postData` for the attribute `pickwareStockManagementDisabled` and, if set, either starts or
     * stops managing the passed `$articleDetail`'s stock, depending on the value.
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockManagementStatusWithPostData(ArticleDetail $articleDetail, array $postData);

    /**
     * Checks the passed `$postData` for the `stockMin` field and, if present, initializes the stock limits of the
     * passed `$articleDetail` to the respective value.
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockLimitsWithPostData(ArticleDetail $articleDetail, array $postData);

    /**
     * Checks the passed `$postData` for the `inStock` field and, if present, updates the (physical) stock
     * of the passed `$articleDetail` in accordance with the passed `inStock` value.
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockWithPostData(ArticleDetail $articleDetail, array $postData);
}
