<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi;

use Shopware\Models\Article\Detail as ArticleDetail;

trait RestApiArticleDetailUpdaterServiceDecoration
{
    /**
     * @var RestApiArticleDetailUpdater
     */
    protected $decoratedService;

    /**
     * @see RestApiArticleDetailUpdater::removeCustomAttributesFromPostData()
     *
     * @param array $postData
     * @return array
     */
    public function removeCustomAttributesFromPostData(array $postData)
    {
        return $this->decoratedService->removeCustomAttributesFromPostData($postData);
    }

    /**
     * @see RestApiArticleDetailUpdater::removeStockFieldsFromPostData()
     *
     * @param array $postData
     * @return array
     */
    public function removeStockFieldsFromPostData(array $postData)
    {
        return $this->decoratedService->removeStockFieldsFromPostData($postData);
    }

    /**
     * @see RestApiArticleDetailUpdater::updateStockManagementStatusWithPostData()
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockManagementStatusWithPostData(ArticleDetail $articleDetail, array $postData)
    {
        $this->decoratedService->updateStockManagementStatusWithPostData($articleDetail, $postData);
    }

    /**
     * @see RestApiArticleDetailUpdater::updateStockLimitsWithPostData()
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockLimitsWithPostData(ArticleDetail $articleDetail, array $postData)
    {
        $this->decoratedService->updateStockLimitsWithPostData($articleDetail, $postData);
    }

    /**
     * @see RestApiArticleDetailUpdater::updateStockWithPostData()
     *
     * @param ArticleDetail $articleDetail
     * @param array $postData
     */
    public function updateStockWithPostData(ArticleDetail $articleDetail, array $postData)
    {
        $this->decoratedService->updateStockWithPostData($articleDetail, $postData);
    }
}
