<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Routing;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;

abstract class AbstractRestApiRouterSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            RestApiRouterService::EVENT_REST_API_CONTROLLER_ROUTING => 'onRestApiControllerRouting',
        ];
    }

    /**
     * Applies custom routing for the given request.
     *
     * That is, if the request should be routed to a custom API controller, the name of that controller must be
     * returned. Otherwise `null` must be returned to indicate that no custom routing is required.
     *
     * @param \Enlight_Controller_Request_Request $request
     * @return string|null
     */
    abstract public function applyCustomRouting(\Enlight_Controller_Request_Request $request);

    /**
     * @param \Enlight_Event_EventArgs $args
     * @return string|null
     */
    public function onRestApiControllerRouting(\Enlight_Event_EventArgs $args)
    {
        $request = $args->get('request');

        return $this->applyCustomRouting($request);
    }
}
