<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Routing;

final class RestApiRouterService
{
    /**
     * The name of the event, which is fired to perform custom API routing.
     */
    const EVENT_REST_API_CONTROLLER_ROUTING = 'Shopware_Plugins_ViisonPickwareERP_RestApiRouter_RestApiControllerRouting';

    /**
     * @var \Enlight_Event_EventManager $eventManager;
     */
    private $eventManager;

    /**
     * @param \Enlight_Event_EventManager $eventManager
     */
    public function __construct(\Enlight_Event_EventManager $eventManager)
    {
        $this->eventManager = $eventManager;
    }

    /**
     * Determines whether the given request targets a custom REST API resource and/or action and,
     * if this is the case fires an event to allow subscribed plugins to perform custom routing.
     *
     * @param \Enlight_Controller_Request_Request $request
     * @return string
     */
    public function getControllerNameForRequest(\Enlight_Controller_Request_Request $request)
    {
        // Prevent custom routing for any other modules than API
        if ($request->getModuleName() !== 'api') {
            return $request->getControllerName();
        }

        // Perform custom routing by firing the notify until event
        $controllerName = $this->eventManager->notifyUntil(
            static::EVENT_REST_API_CONTROLLER_ROUTING,
            [
                'request' => $request,
            ]
        );
        if (!$controllerName || !$controllerName->getReturn()) {
            // Use original controller name
            return $request->getControllerName();
        }

        return $controllerName->getReturn();
    }
}
