<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment;

interface ReturnShipmentMailing
{
    /**
     * Sends an email that informs the customer that his returned items have been received.
     *
     * @param ReturnShipment $returnShipment
     * @throws ReturnShipmentMailingException
     */
    public function sendReturnReceivedEmail(ReturnShipment $returnShipment);

    /**
     * Sends an email that informs the customer that his returned items have been completed.
     *
     * @param ReturnShipment $returnShipment
     * @throws ReturnShipmentMailingException
     */
    public function sendReturnCompletedEmail(ReturnShipment $returnShipment);

    /**
     * @param ReturnShipment $returnShipment
     * @return \Enlight_Components_Mail
     */
    public function createReturnReceivedMail(ReturnShipment $returnShipment);

    /**
     * @param ReturnShipment $returnShipment
     * @return \Enlight_Components_Mail
     */
    public function createReturnCompletedMail(ReturnShipment $returnShipment);
}
