<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment;

trait ReturnShipmentMailingDecoration
{
    /**
     * @var ReturnShipmentMailing
     */
    private $decoratedService;

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentMailing::sendReturnReceivedEmail
     *
     * @param ReturnShipment $returnShipment
     */
    public function sendReturnReceivedEmail(ReturnShipment $returnShipment)
    {
        $this->decoratedService->sendReturnReceivedEmail($returnShipment);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentMailing::sendReturnCompletedEmail
     *
     * @param ReturnShipment $returnShipment
     */
    public function sendReturnCompletedEmail(ReturnShipment $returnShipment)
    {
        $this->decoratedService->sendReturnCompletedEmail($returnShipment);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentMailing::createReturnReceivedMail
     *
     * @param ReturnShipment $returnShipment
     * @return \Enlight_Components_Mail
     */
    public function createReturnReceivedMail(ReturnShipment $returnShipment)
    {
        return $this->decoratedService->createReturnReceivedMail($returnShipment);
    }

    /**
     * @see \Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentMailing::sendReturnCompletedEmail
     *
     * @param ReturnShipment $returnShipment
     * @return \Enlight_Components_Mail
     */
    public function createReturnCompletedMail(ReturnShipment $returnShipment)
    {
        return $this->decoratedService->sendReturnCompletedEmail($returnShipment);
    }
}
