<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment;
use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipmentItem;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\BinLocation;
use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonCommon\Classes\Exceptions\NumberRangeNotFoundException;

interface ReturnShipmentProcessor
{
    /**
     * @param Order $order
     * @return ReturnShipment
     * @throws NumberRangeNotFoundException
     */
    public function createReturnShipment(Order $order);

    /**
     * @param ReturnShipmentItem $returnShipmentItem
     * @param int $newReturnedQuantity New returnedQuantity value
     * @param int $newWrittenOffQuantity New writtenOffQuantity value
     * @return bool
     */
    public function isReturnedAndWrittenOffQuantityAllowed(ReturnShipmentItem $returnShipmentItem, $newReturnedQuantity, $newWrittenOffQuantity);

    /**
     * Write stock entries for the changes made to ReturnShipmentItem $item to the database.
     *
     * This method is idempotent.
     *
     * @param ReturnShipmentItem $item
     */
    public function writeStockEntriesForItemChangesWithAutomaticBinLocationSelection(ReturnShipmentItem $item);

    /**
     * Write stock entries for the changes made to ReturnShipmentItem $item to the database.
     *
     * This method is idempotent.
     *
     * @param ReturnShipmentItem $item
     * @param BinLocation $binLocation
     */
    public function writeStockEntriesForItemChangesOnBinLocation(ReturnShipmentItem $item, BinLocation $binLocation);

    /**
     * @param Order $order
     */
    public function updateAccumulatedReturnShipmentStatus(Order $order);

    /**
     * @param ReturnShipment $returnShipment
     */
    public function safelyDeleteReturnShipment(ReturnShipment $returnShipment);

    /**
     * @param ReturnShipmentItem $returnShipmentItem
     */
    public function safelyDeleteReturnShipmentItem(ReturnShipmentItem $returnShipmentItem);
}
