<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment;
use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipmentItem;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\BinLocation;
use Shopware\Models\Order\Order;

trait ReturnShipmentProcessorDecoration
{
    /**
     * @var ReturnShipmentProcessor
     */
    private $decoratedInstance;

    /**
     * @param Order $order
     * @return ReturnShipment
     */
    public function createReturnShipment(Order $order)
    {
        return $this->decoratedInstance->createReturnShipment($order);
    }

    /**
     * @param ReturnShipmentItem $returnShipmentItem
     * @param int $newReturnedQuantity New returnedQuantity value
     * @param int $newWrittenOffQuantity New writtenOffQuantity value
     * @return bool
     */
    public function isReturnedAndWrittenOffQuantityAllowed(ReturnShipmentItem $returnShipmentItem, $newReturnedQuantity, $newWrittenOffQuantity)
    {
        return $this->decoratedInstance->isReturnedAndWrittenOffQuantityAllowed(
            $returnShipmentItem,
            $newReturnedQuantity,
            $newWrittenOffQuantity
        );
    }

    /**
     * @param ReturnShipmentItem $item
     */
    public function writeStockEntriesForItemChangesWithAutomaticBinLocationSelection(ReturnShipmentItem $item)
    {
        $this->decoratedInstance->writeStockEntriesForItemChangesWithAutomaticBinLocationSelection($item);
    }

    /**
     * @param ReturnShipmentItem $item
     * @param BinLocation $binLocation
     */
    public function writeStockEntriesForItemChangesOnBinLocation(ReturnShipmentItem $item, BinLocation $binLocation)
    {
        $this->decoratedInstance->writeStockEntriesForItemChangesOnBinLocation($item, $binLocation);
    }

    /**
     * @param Order $order
     */
    public function updateAccumulatedReturnShipmentStatus(Order $order)
    {
        $this->decoratedInstance->updateAccumulatedReturnShipmentStatus($order);
    }

    /**
     * @param ReturnShipment $returnShipment
     */
    public function safelyDeleteReturnShipment(ReturnShipment $returnShipment)
    {
        $this->decoratedInstance->safelyDeleteReturnShipment($returnShipment);
    }

    /**
     * @param ReturnShipmentItem $returnShipmentItem
     */
    public function safelyDeleteReturnShipmentItem(ReturnShipmentItem $returnShipmentItem)
    {
        $this->decoratedInstance->safelyDeleteReturnShipmentItem($returnShipmentItem);
    }
}
