<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use BadMethodCallException;
use Doctrine\DBAL\Connection as DbalConnection;
use Doctrine\DBAL\DBALException;

class ArticleDetailConcurrencyCoordinatorService implements ArticleDetailConcurrencyCoordinator
{
    /**
     * @var DbalConnection
     */
    private $dbalConnection;

    public function __construct($dbalConnection)
    {
        $this->dbalConnection = $dbalConnection;
    }

    /**
     * @inheritDoc
     */
    public function lockArticleDetailIds(...$articleDetailIds)
    {
        if ($this->dbalConnection->getTransactionNestingLevel() < 1) {
            throw new BadMethodCallException('Please start a transaction before trying to lock article detail IDs.');
        }

        try {
            $this->dbalConnection->fetchAll(
                'SELECT id
                FROM s_articles_details
                WHERE id IN (:articleDetailIds)
                FOR UPDATE',
                [
                    'articleDetailIds' => $articleDetailIds,
                ],
                [
                    'articleDetailIds' => DbalConnection::PARAM_INT_ARRAY,
                ]
            );
        } catch (DBALException $dbalException) {
            throw ArticleDetailConcurrencyException::map($dbalException, $articleDetailIds);
        }
    }
}
